/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletContext;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.util.SpacePageUtils;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.gatein.api.ApiException;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.NavigationImpl;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.security.Group;
import org.gatein.api.site.SiteId;
import org.jgroups.util.DefaultThreadFactory;

public class SpaceNavigationMigration {
    private static final Log LOG = ExoLogger.getLogger(SpaceNavigationMigration.class);
    private SpaceService spaceService;
    private CSSpaceService cSSpaceService;
    private UserPortalConfigService portalConfigService;
    private NavigationService navigationService;
    private DescriptionService descriptionService;
    private ResourceBundleManager bundleManager;
    public static final String CS_SPACES_NAVIGATION_MIGRATION_DONE_KEY = "CS_SPACES_NAVIGATION_MIGRATION_DONE_KEY";
    public static final String CS_SPACES_NAVIGATION_MIGRATION_DONE = "CS_SPACES_NAVIGATION_MIGRATION_DONE";
    private static ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("CS-SPACES-NAV-MIGRATION", false, false));

    public SpaceNavigationMigration(SpaceService spaceService, CSSpaceService cSSpaceService, UserPortalConfigService portalConfigService, NavigationService navigationService, DescriptionService descriptionService, ResourceBundleManager bundleManager) {
        this.spaceService = spaceService;
        this.cSSpaceService = cSSpaceService;
        this.portalConfigService = portalConfigService;
        this.navigationService = navigationService;
        this.descriptionService = descriptionService;
        this.bundleManager = bundleManager;
    }

    public void migrate() {
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                        if (SpaceNavigationMigration.isSpaceNavigationlMigrated()) {
                            try {
                                ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                                LOG.info((Object)"=== Start migration of Spaces Navigation");
                                long startTime = System.currentTimeMillis();
                                SpaceNavigationMigration.this.migrateNav();
                                long endTime = System.currentTimeMillis();
                                LOG.info((Object)("=== Migration of Spaces Navigation is done in " + (endTime - startTime) + " ms"));
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error while migrating Spaces Navigation - Cause : " + e.getMessage()), (Throwable)e);
                            }
                        } else {
                            LOG.info((Object)"No Spaces Navigation to migrate");
                        }
                        return null;
                    }
                });
            }
        });
    }

    private void migrateNav() {
        int i = 1;
        List<SpaceDTO> csspaces = this.cSSpaceService.getAllSpaces();
        for (SpaceDTO cspace : csspaces) {
            Space space = this.spaceService.getSpaceByGroupId(cspace.getGroupId());
            if (space != null) {
                LOG.info((Object)(i + "/" + csspaces.size() + "----- Start update nav of Space " + space.getDisplayName()));
                try {
                    this.portalConfigService.createUserPortalConfig(PortalConfig.GROUP_TYPE, space.getGroupId(), "CSSpace");
                    SiteKey siteKey = SiteKey.group((String)space.getGroupId());
                    Navigation navigation = this.getNav(space, siteKey);
                    Node home = navigation.getNode(NodePath.path((String[])new String[]{space.getUrl()}), Nodes.visitAll());
                    Node tempHome = navigation.getNode(NodePath.path((String[])new String[]{"cs"}), Nodes.visitAll());
                    for (Node childNode : tempHome) {
                        if (home.hasChild(childNode.getName())) {
                            if (childNode.getName().equals("guide")) break;
                            home.removeChild(childNode.getName());
                        }
                        Node newNode = home.addChild(childNode.getName());
                        newNode.setIconName(childNode.getIconName());
                        newNode.setPageId(childNode.getPageId());
                        newNode.setVisibility(childNode.getVisibility());
                        navigation.saveNode(home);
                        navigation.removeNode(childNode.getNodePath());
                        this.convertChildApplicationPreferences(space, siteKey, newNode);
                    }
                    home.setPageId(tempHome.getPageId());
                    navigation.saveNode(home);
                    this.convertChildApplicationPreferences(space, siteKey, home);
                    navigation.removeNode(tempHome.getNodePath());
                }
                catch (Exception e) {
                    LOG.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                }
            }
            LOG.info((Object)("----- Space " + space.getDisplayName() + " Nav updated"));
            ++i;
        }
        SpaceNavigationMigration.setSpaceNavigationMigrationDone();
    }

    private Navigation getNav(Space space, SiteKey siteKey) {
        try {
            NavigationContext ctx = this.navigationService.loadNavigation(siteKey);
            if (ctx == null) {
                return null;
            }
            Group group = new Group(space.getGroupId());
            return new NavigationImpl(new SiteId(group), this.navigationService, ctx, this.descriptionService, this.bundleManager);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to load navigation", t);
        }
    }

    private void convertChildApplicationPreferences(Space space, SiteKey siteKey, Node newNode) throws Exception {
        PageKey pageKey = new PageKey(siteKey, newNode.getPageId().getPageName());
        Page newPage = PageUtils.getPage((DataStorage)this.portalConfigService.getDataStorage(), (PageService)this.portalConfigService.getPageService(), (PageKey)pageKey);
        ArrayList modelObjects = newPage.getChildren();
        SpacePageUtils.convert(modelObjects, space.getGroupId());
    }

    public static void setSpaceNavigationMigrationDone() {
        ((SettingService)CommonsUtils.getService(SettingService.class)).set(Context.GLOBAL, Scope.APPLICATION.id(CS_SPACES_NAVIGATION_MIGRATION_DONE_KEY), CS_SPACES_NAVIGATION_MIGRATION_DONE, SettingValue.create((String)"true"));
    }

    public static boolean isSpaceNavigationlMigrated() {
        SettingValue setting = ((SettingService)CommonsUtils.getService(SettingService.class)).get(Context.GLOBAL, Scope.APPLICATION.id(CS_SPACES_NAVIGATION_MIGRATION_DONE_KEY), CS_SPACES_NAVIGATION_MIGRATION_DONE);
        return setting != null && setting.getValue().equals("true");
    }
}

