/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.Calendar;
import java.util.List;
import javax.persistence.TemporalType;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicDAO
extends GenericDAOJPAImpl<TopicEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(TopicDAO.class);

    public List<TopicEntity> getTopicsBySpace(String spaceGroupId, String selectedStatus) {
        try {
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndStatus", TopicEntity.class).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)spaceGroupId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)spaceGroupId).getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics of space '" + spaceGroupId + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByAssignee(String assignee, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by assignee '" + assignee + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByAssignee(String assignee, String selectedSpace, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByAssigneeAndSpace", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by assignee '" + assignee + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getOpenTickets() {
        return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopics", TopicEntity.class).setParameter("status", (Object)"closed").getResultList();
    }

    public List<TopicEntity> findUpdatedBetween(Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findUpdatedTopics", TopicEntity.class).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public Long countTickets(SpaceEntity space, IssueType type) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countTickets", Long.class).setParameter("type", (Object)type).setParameter("space", (Object)space).getSingleResult();
    }

    @Deprecated
    public List<TopicEntity> getEmptyTitleOrCreationDate() {
        return this.getEntityManager().createNamedQuery("topicEntity.findEmptyTitleAndCreationDateTopics", TopicEntity.class).setMaxResults(50).getResultList();
    }

    public List<TopicEntity> getWithEmptyTicketID() {
        return this.getEntityManager().createNamedQuery("topicEntity.findEmptyTicketID", TopicEntity.class).setMaxResults(50).getResultList();
    }

    public List<TopicEntity> getOpenTicketsBySpace(String selectedSpace, String selectedStatus) {
        if (selectedStatus != null && !selectedStatus.isEmpty()) {
            return this.getEntityManager().createNamedQuery("topicEntity.findOpenTicketsBySpaceAndStatus", TopicEntity.class).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("status", (Object)selectedStatus).setParameter("closedStatus", (Object)"closed").getResultList();
        }
        return this.getEntityManager().createNamedQuery("topicEntity.findOpenTicketsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("closedStatus", (Object)"closed").getResultList();
    }

    public TopicEntity findByTicketId(String ticketId) {
        return (TopicEntity)this.getEntityManager().createNamedQuery("topicEntity.findTicketByTicketId", TopicEntity.class).setParameter("ticketId", (Object)ticketId).getSingleResult();
    }

    public List<TopicEntity> findByStatus(String selectedStatus) {
        return this.getEntityManager().createNamedQuery("topicEntity.findAllTicketByStatus", TopicEntity.class).setParameter("status", (Object)selectedStatus).getResultList();
    }

    public List<TopicEntity> getOpenTicketsByStatus(String selectedStatus) {
        if (selectedStatus != null && !selectedStatus.isEmpty()) {
            return this.getEntityManager().createNamedQuery("topicEntity.findOpenTicketsByStatus", TopicEntity.class).setParameter("status", (Object)selectedStatus).setParameter("closedStatus", (Object)"closed").getResultList();
        }
        return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopics", TopicEntity.class).setParameter("status", (Object)"closed").getResultList();
    }

    public List<TopicEntity> getTopicsByCreator(String creator, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByCreator", TopicEntity.class).setParameter("creator", (Object)creator).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByCreator", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by creator '" + creator + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByCreator(String creator, String selectedSpace, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndCreator", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByCreatorAndSpace", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by creator '" + creator + "'.", (Throwable)e);
            throw e;
        }
    }
}

