/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.cs.listener.ForumListener;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class CSUtils {
    private static final Log LOG = ExoLogger.getLogger(ForumListener.class);
    private static OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
    private static final String SUPPORT_GROUP_NAME_CONFIGURATION = "exo.addon.cs.support.group.name";
    private static final String INTERNAL_SUPPORT_GROUP_ID_CONFIGURATION = "exo.addon.cs.internal.support.group.id";
    private static final String MANAGERS_GROUP_NAME_CONFIGURATION = "exo.addon.cs.managers.group.name";
    private static final String AUTO_ASSIGNEES_GROUP_NAME_CONFIGURATION = "exo.addon.cs.auto.assignee.group.name";

    public static List<User> getSupportMembers() {
        return CSUtils.getGroupMembers(CSUtils.getSupportTeamGroup());
    }

    public static List<User> getInternalSupportMembers() {
        String groupId = CSUtils.getInternalSupportTeamGroup();
        return groupId != null ? CSUtils.getGroupMembers(groupId) : null;
    }

    public static String getSupportTeamGroup() {
        String groupId = PropertyManager.getProperty((String)SUPPORT_GROUP_NAME_CONFIGURATION);
        if (groupId == null || groupId.isEmpty()) {
            groupId = "support-team";
        }
        return groupId;
    }

    public static String getInternalSupportTeamGroup() {
        block4: {
            String groupId = PropertyManager.getProperty((String)INTERNAL_SUPPORT_GROUP_ID_CONFIGURATION);
            if (groupId == null || groupId.isEmpty()) {
                groupId = "/spaces/exo_support";
            }
            try {
                if (organizationService.getGroupHandler().findGroupById(groupId) != null) {
                    return groupId;
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error("Group {} does not exist", new Object[]{groupId, e});
            }
        }
        return null;
    }

    public static List<User> getSupportManagers() {
        return CSUtils.getGroupMembers(CSUtils.getSupportManagersGroup());
    }

    public static List<User> getSupportAutoAssignees() {
        String groupId = PropertyManager.getProperty((String)AUTO_ASSIGNEES_GROUP_NAME_CONFIGURATION);
        if (groupId == null || groupId.isEmpty()) {
            groupId = "support-assignee";
        }
        return CSUtils.getGroupMembers(groupId);
    }

    public static String getSupportManagersGroup() {
        String groupId = PropertyManager.getProperty((String)MANAGERS_GROUP_NAME_CONFIGURATION);
        if (groupId == null || groupId.isEmpty()) {
            groupId = "gss";
        }
        return groupId;
    }

    public static List<User> getGroupMembers(String groupId) {
        try {
            ListAccess engSupportList = organizationService.getUserHandler().findUsersByGroupId(groupId);
            User[] users = (User[])engSupportList.load(0, engSupportList.getSize());
            return Arrays.asList(users);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot get the list of group members");
            return new ArrayList<User>();
        }
    }

    public static boolean isMemberof(String user, String groupId) {
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        try {
            if (organizationService.getMembershipHandler().findMembershipsByUserAndGroup(user, groupId).size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Can not check the membership of {} in group {}", new Object[]{user, groupId, e});
            return false;
        }
        return false;
    }

    public static Boolean canManage() {
        Identity currentId = ConversationState.getCurrent().getIdentity();
        if (currentId.isMemberOf("/" + CSUtils.getSupportTeamGroup()) || currentId.isMemberOf("/platform/administrators")) {
            return true;
        }
        return false;
    }

    public static Calendar getNextDate(Calendar c, long delay) {
        Calendar next = Calendar.getInstance();
        next.setTime(c.getTime());
        next.setTimeZone(TimeZone.getTimeZone("GMT+01"));
        next.setTimeInMillis(next.getTimeInMillis() + delay);
        while (next.get(7) == 7 || next.get(7) == 1) {
            next.add(5, 1);
        }
        return next;
    }

    public static long getDiffBetweenTwoDates(Calendar c1, Calendar c2) {
        Calendar from = Calendar.getInstance();
        from.setTime(c1.getTime());
        Calendar to = Calendar.getInstance();
        to.setTime(c2.getTime());
        if (from.get(11) > 18) {
            from.add(5, 1);
            from.set(11, 9);
            from.set(12, 0);
        }
        if (from.get(11) < 9) {
            from.set(11, 9);
            from.set(12, 0);
        }
        if (to.get(11) > 18) {
            to.set(11, 18);
            to.set(12, 0);
        }
        if (to.get(11) < 9) {
            to.add(5, -1);
            to.set(11, 18);
            to.set(12, 0);
        }
        while (from.get(7) == 7 || from.get(7) == 1) {
            from.add(5, 1);
            from.set(11, 9);
            from.set(12, 0);
        }
        long diff = to.getTimeInMillis() - from.getTimeInMillis();
        while (from.before(to)) {
            if (from.get(7) == 7 || from.get(7) == 1) {
                diff -= 86400000L;
            }
            from.add(5, 1);
        }
        return diff < 0L ? 0L : diff;
    }

    public static String formatDate(String date, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        Calendar today = Calendar.getInstance(timezone);
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTime(new Date(Long.parseLong(date)));
        String format = "MMM dd yyyy";
        if (cal.get(1) == today.get(1)) {
            format = "MMM dd";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(timezone);
        return df.format(cal.getTime());
    }

    public static TimeZone getUserTimezone(String username) {
        try {
            CalendarService calService = (CalendarService)CommonsUtils.getService(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception e) {
            LOG.error((Object)"Can't retrieve timezone", (Throwable)e);
            return null;
        }
    }

    public static String getDefaultState(String flow) {
        TicketStatusFlowService ticketStatusFlowService = (TicketStatusFlowService)CommonsUtils.getService(TicketStatusFlowService.class);
        return ticketStatusFlowService.getFlowbyName(flow).getDefaultState();
    }
}

