/*
 *
 *  * Copyright (C) 2003-2016 eXo Platform SAS.
 *  *
 *  * This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Affero General Public License
 *  as published by the Free Software Foundation; either version 3
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see<http://www.gnu.org/licenses/>.
 *
 */
package org.exoplatform.cs.service;

import org.exoplatform.cs.dao.StatLogDAO;
import org.exoplatform.cs.dto.StatLogDTO;
import org.exoplatform.cs.entity.StatLogEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

import java.util.*;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
public class StatsService {
  private static final Log LOG = ExoLogger.getLogger(StatsService.class);


    private StatLogDAO      statLogDAO;


  public StatsService() {
      this.statLogDAO = new StatLogDAO();
    }



    public StatLogEntity save(StatLogEntity entity) {
      try {
        if (entity == null) {
          throw new IllegalStateException("Parameter 'entity' is null");
        }

          return statLogDAO.create(entity);

      } catch (IllegalStateException e) {
        LOG.error("Cannot save the stat", e.getMessage());
      }
      return null;
    }

  public List<StatLogDTO> getStatsByTypeAndDate(String type,  Calendar statDate) {
    List<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
    List<StatLogEntity> entities = new ArrayList<StatLogEntity>();
    try {
        entities = statLogDAO.getStatsByTypeAndDate(type,statDate);
      for (StatLogEntity entity : entities) {
        dtos.add(convert(entity));
      }
    } catch (Exception e) {
      LOG.error("Cannot get stats", e.getMessage());
    }
    return dtos;
  }

    public List<StatLogDTO> getAllStatsByType(String type, Calendar startDate, Calendar endDate) {
      List<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
      List<StatLogEntity> entities = new ArrayList<StatLogEntity>();
      try {
        if(startDate == null || endDate == null){
          entities = statLogDAO.getAllStatsByType(type);
        }else{
          entities = statLogDAO.getAllStatsByTypeAndDates(type, startDate, endDate);
        }

        for (StatLogEntity entity : entities) {
          dtos.add(convert(entity));
        }
      } catch (Exception e) {
        LOG.error("Cannot get stats", e.getMessage());
      }
      return dtos;
    }

  public List<StatLogDTO> getWeeklyStatsByType(String type, Calendar startDate, Calendar endDate) {
    List<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
    List<StatLogEntity> entities = new ArrayList<StatLogEntity>();
    try {
      if(startDate == null || endDate == null){
        entities = statLogDAO.getWeeklyStatsByType(type);
      }else{
        entities = statLogDAO.getWeeklyStatsByTypeAndDates(type, startDate, endDate);
      }

      for (StatLogEntity entity : entities) {
        dtos.add(convert(entity));
      }
    } catch (Exception e) {
      LOG.error("Cannot get stats", e.getMessage());
    }
    return dtos;
  }

  public List<StatLogDTO> getMonthlyStatsByType(String type, Calendar startDate, Calendar endDate) {
    List<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
    List<StatLogEntity> entities = new ArrayList<StatLogEntity>();
    try {
      if(startDate == null || endDate == null){
        entities = statLogDAO.getMonthlyStatsByType(type);
      }else{
        entities = statLogDAO.getMonthlyStatsByTypeAndDates(type, startDate, endDate);
      }

      for (StatLogEntity entity : entities) {
        dtos.add(convert(entity));
      }
    } catch (Exception e) {
      LOG.error("Cannot get stats", e.getMessage());
    }
    return dtos;
  }


  private StatLogEntity convert(StatLogDTO dto) {
    StatLogEntity entity = new StatLogEntity();
    entity.setId(dto.getId());
    entity.setStatDate(dto.getStatDate());
    entity.setStatType(dto.getStatType());
    entity.setStatus(dto.getStatus());
    entity.setTicketsNumber(dto.getTicketsNumber());
    entity.setWeekly(dto.getWeekly());
    entity.setMonthly(dto.getMonthly());
    entity.setSpaceId(dto.getSpaceId());

    return entity;
  }

  private StatLogDTO convert(StatLogEntity entity) {
    StatLogDTO dto = new StatLogDTO();
    dto.setId(entity.getId());
    dto.setStatDate(entity.getStatDate());
    dto.setStatType(entity.getStatType());
    dto.setStatus(entity.getStatus());
    dto.setTicketsNumber(entity.getTicketsNumber());
    dto.setWeekly(entity.getWeekly());
    dto.setMonthly(entity.getMonthly());
    dto.setSpaceId(entity.getSpaceId());

    return dto;
  }


}
