/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dao;

import java.util.Calendar;
import java.util.List;
import javax.persistence.TemporalType;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicDAO
extends GenericDAOJPAImpl<TopicEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(TopicDAO.class);

    public List<TopicEntity> getTopicsBySpace(String spaceGroupId, String selectedStatus) {
        try {
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndStatus", TopicEntity.class).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)spaceGroupId).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)spaceGroupId).getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics of space '" + spaceGroupId + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByEnvironment(Long environmentId) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByEnvironment", TopicEntity.class).setParameter("environmentID", (Object)environmentId).getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics By Environment '" + environmentId + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByAssignee(String assignee, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by assignee '" + assignee + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByAssignee(String assignee, String selectedSpace, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndAssignee", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndAssigneeAndStatus", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByAssigneeAndSpace", TopicEntity.class).setParameter("assignee", (Object)assignee).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by assignee '" + assignee + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getOpenTickets() {
        return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopics", TopicEntity.class).setParameter("status", (Object)"closed").getResultList();
    }

    public List<TopicEntity> findUpdatedBetween(Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findUpdatedTopics", TopicEntity.class).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public List<TopicEntity> getUpdatedTicketsByStatus(String status, Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findUpdatedTicketsByStatus", TopicEntity.class).setParameter("status", (Object)status).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public List<TopicEntity> getUpdatedTicketsBySpaceAndStatus(String space, String status, Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findUpdatedTopicsBySpaceAndStatus", TopicEntity.class).setParameter("status", (Object)status).setParameter("spaceGroupID", (Object)space).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public List<TopicEntity> getUpdatedTicketsBySpace(String space, Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findUpdatedTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)space).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public List<TopicEntity> getAllTickets() {
        return this.getEntityManager().createNamedQuery("topicEntity.findAllTickets", TopicEntity.class).getResultList();
    }

    public List<TopicEntity> getAllTicketsWithPagination(int offset, int limit) {
        return this.getEntityManager().createNamedQuery("topicEntity.findAllTickets", TopicEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public List<TopicEntity> getCreatedTicketsBySpace(String space, Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findCreatedTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)space).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public List<TopicEntity> getCreatedTickets(Calendar fromDate, Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findCreatedTopics", TopicEntity.class).setParameter("from", fromDate, TemporalType.TIMESTAMP).setParameter("to", toDate, TemporalType.TIMESTAMP).getResultList();
    }

    public List<TopicEntity> getNotAssignedTicketsBySpace(String space) {
        return this.getEntityManager().createNamedQuery("topicEntity.findNotAssignedTopicsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)space).getResultList();
    }

    public List<TopicEntity> getNotAssignedTickets() {
        return this.getEntityManager().createNamedQuery("topicEntity.findNotAssignedTopics", TopicEntity.class).getResultList();
    }

    public List<TopicEntity> findTicketsForReminder(Calendar toDate) {
        return this.getEntityManager().createNamedQuery("topicEntity.findTicketsForReminder", TopicEntity.class).setParameter("to", (Object)toDate).getResultList();
    }

    public List<TopicEntity> findTicketsForSLAReminder(Calendar instant) {
        return this.getEntityManager().createNamedQuery("topicEntity.findTicketsForSLAReminder", TopicEntity.class).setParameter("instant", (Object)instant).getResultList();
    }

    public Long countTickets(SpaceEntity space, IssueType type) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countTickets", Long.class).setParameter("type", (Object)type).setParameter("space", (Object)space).getSingleResult();
    }

    @Deprecated
    public List<TopicEntity> getEmptyTitleOrCreationDate() {
        return this.getEntityManager().createNamedQuery("topicEntity.findEmptyTitleAndCreationDateTopics", TopicEntity.class).setMaxResults(50).getResultList();
    }

    public List<TopicEntity> getWithEmptyTicketID() {
        return this.getEntityManager().createNamedQuery("topicEntity.findEmptyTicketID", TopicEntity.class).setMaxResults(50).getResultList();
    }

    public List<TopicEntity> getOpenTicketsBySpace(String selectedSpace, String selectedStatus) {
        if (selectedStatus != null && !selectedStatus.isEmpty()) {
            return this.getEntityManager().createNamedQuery("topicEntity.findOpenTicketsBySpaceAndStatus", TopicEntity.class).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("status", (Object)selectedStatus).setParameter("closedStatus", (Object)"closed").getResultList();
        }
        return this.getEntityManager().createNamedQuery("topicEntity.findOpenTicketsBySpace", TopicEntity.class).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("closedStatus", (Object)"closed").getResultList();
    }

    public TopicEntity findByTicketId(String ticketId) {
        return (TopicEntity)this.getEntityManager().createNamedQuery("topicEntity.findTicketByTicketId", TopicEntity.class).setParameter("ticketId", (Object)ticketId).getSingleResult();
    }

    public List<TopicEntity> findByStatus(String selectedStatus) {
        return this.getEntityManager().createNamedQuery("topicEntity.findAllTicketByStatus", TopicEntity.class).setParameter("status", (Object)selectedStatus).getResultList();
    }

    public List<TopicEntity> getOpenTicketsByStatus(String selectedStatus) {
        if (selectedStatus != null && !selectedStatus.isEmpty()) {
            return this.getEntityManager().createNamedQuery("topicEntity.findOpenTicketsByStatus", TopicEntity.class).setParameter("status", (Object)selectedStatus).setParameter("closedStatus", (Object)"closed").getResultList();
        }
        return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopics", TopicEntity.class).setParameter("status", (Object)"closed").getResultList();
    }

    public List<TopicEntity> getTopicsByCreator(String creator, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByCreator", TopicEntity.class).setParameter("creator", (Object)creator).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsByCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByCreator", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by creator '" + creator + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<TopicEntity> getTopicsByCreator(String creator, String selectedSpace, boolean allTickets, String selectedStatus) {
        try {
            if (allTickets) {
                if (selectedStatus != null && !selectedStatus.isEmpty()) {
                    return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
                }
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndCreator", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            if (selectedStatus != null && !selectedStatus.isEmpty()) {
                return this.getEntityManager().createNamedQuery("topicEntity.getTopicsBySpaceAndCreatorAndStatus", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("status", (Object)selectedStatus).setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
            }
            return this.getEntityManager().createNamedQuery("topicEntity.getOpenTopicsByCreatorAndSpace", TopicEntity.class).setParameter("creator", (Object)creator).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("status", (Object)"closed").getResultList();
        }
        catch (Exception e) {
            LOG.error("Exception while attempting to get topics by creator '" + creator + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdBySpace(boolean internal) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdBySpace", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdByOwner(boolean internal) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdByOwner", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdByStatus(boolean internal) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdByStatus", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countSpaceTicketsGroupdByStatus(String selectedSpace) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countSpaceTicketsGroupdByStatus", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countSpaceTicketsGroupdByOwner(String selectedSpace) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countSpaceTicketsGroupdByOwner", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countSpaceTicketsGroupdByAssignee(String selectedSpace) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countSpaceTicketsGroupdByAssignee", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countOpenCustomerTickets(boolean internal) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countOpenCustomerTickets", Long.class).setParameter("internal", (Object)internal).setParameter("closedStatus", (Object)"closed").getSingleResult();
    }

    public Long countClosedCustomerTickets(boolean internal) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countClosedCustomerTickets", Long.class).setParameter("internal", (Object)internal).setParameter("closedStatus", (Object)"closed").getSingleResult();
    }

    public Long countOpenSpaceTickets(String selectedSpace) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countOpenSpaceTickets", Long.class).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("closedStatus", (Object)"closed").getSingleResult();
    }

    public Long countClosedSpaceTickets(String selectedSpace) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countClosedSpaceTickets", Long.class).setParameter("spaceGroupID", (Object)selectedSpace).setParameter("closedStatus", (Object)"closed").getSingleResult();
    }

    public Long countOpenCustomerTicketsByDates(boolean internal, Calendar from, Calendar to) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countOpenCustomerTicketsByDates", Long.class).setParameter("internal", (Object)internal).setParameter("from", from, TemporalType.TIMESTAMP).setParameter("to", to, TemporalType.TIMESTAMP).getSingleResult();
    }

    public Long countClosedCustomerTicketsByDates(boolean internal, Calendar from, Calendar to) {
        return (Long)this.getEntityManager().createNamedQuery("topicEntity.countClosedCustomerTicketsByDates", Long.class).setParameter("internal", (Object)internal).setParameter("closedStatus", (Object)"closed").setParameter("from", from, TemporalType.TIMESTAMP).setParameter("to", to, TemporalType.TIMESTAMP).getSingleResult();
    }

    public List<Object[]> countCustomerTicketsGroupdByStatusAndDates(boolean internal, Calendar from, Calendar to) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdByStatusAndDates", Object[].class).setParameter("internal", (Object)internal).setParameter("closedStatus", (Object)"closed").setParameter("from", from, TemporalType.TIMESTAMP).setParameter("to", to, TemporalType.TIMESTAMP).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdByAssigneeAndDates(boolean internal, Calendar from, Calendar to) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdByAssigneeAndDates", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).setParameter("from", from, TemporalType.TIMESTAMP).setParameter("to", to, TemporalType.TIMESTAMP).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdByAssignee(boolean internal) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdByAssignee", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countUnresolvedTicketsGroupdByAssignee() {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countUnresolvedTicketsGroupdByAssignee", Object[].class).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdBySeverityAndDates(boolean internal, Calendar from, Calendar to) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdBySeverityAndDates", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).setParameter("from", from, TemporalType.TIMESTAMP).setParameter("to", to, TemporalType.TIMESTAMP).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countCustomerTicketsGroupdBySeverity(boolean internal) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countCustomerTicketsGroupdBySeverity", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("internal", (Object)internal).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countSpaceTicketsGroupdBySeverity(String selectedSpace) {
        try {
            return this.getEntityManager().createNamedQuery("topicEntity.countSpaceTicketsGroupdBySeverity", Object[].class).setParameter("closedStatus", (Object)"closed").setParameter("spaceGroupID", (Object)selectedSpace).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public double getTimeToResolutionAvg(boolean internal) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("topicEntity.getTimeToResolutionAvg", Double.class).setParameter("internal", (Object)internal).getSingleResult();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public double getTimeToFirstResponseAvg(boolean internal) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("topicEntity.getTimeToFirstResponseAvg", Double.class).setParameter("internal", (Object)internal).getSingleResult();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countSatisfiedTicketNumber(boolean internal) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("topicEntity.countSatisfiedTicketNumber", Long.class).setParameter("internal", (Object)internal).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countNotSatisfiedTicketNumber(boolean internal) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("topicEntity.countNotSatisfiedTicketNumber", Long.class).setParameter("internal", (Object)internal).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public double getSpaceTimeToResolutionAvg(String selectedSpace) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("topicEntity.getSpaceTimeToResolutionAvg", Double.class).setParameter("spaceGroupID", (Object)selectedSpace).getSingleResult();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public double getSpaceTimeToFirstResponseAvg(String selectedSpace) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("topicEntity.getSpaceTimeToFirstResponseAvg", Double.class).setParameter("spaceGroupID", (Object)selectedSpace).getSingleResult();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countSpaceSatisfiedTicketNumber(String selectedSpace) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("topicEntity.countSpaceSatisfiedTicketNumber", Long.class).setParameter("spaceGroupID", (Object)selectedSpace).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public Long countSpaceNotSatisfiedTicketNumber(String selectedSpace) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("topicEntity.countSpaceNotSatisfiedTicketNumber", Long.class).setParameter("spaceGroupID", (Object)selectedSpace).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }
}

