package org.exoplatform.cs.integration.notification;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CSAnnouncementPlugin extends BaseNotificationPlugin {
    public static final String ID = "CSAnnouncementPlugin";



    public CSAnnouncementPlugin(InitParams initParams ) {
        super(initParams);
    }


    @Override

    public String getId() {

        return ID;

    }


    @Override

    public boolean isValid(NotificationContext ctx) {

        return true;

    }




    @Override

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        Set<String> receivers = new HashSet<String>();
        CSSpaceService csSpaceService = CommonsUtils.getService(CSSpaceService.class);
        SpaceService spaceService = CommonsUtils.getService(SpaceService.class);
        List<SpaceDTO> spaces = csSpaceService.getAllSpaces();
        for (SpaceDTO space :spaces){
            Space space_ = spaceService.getSpaceByGroupId(space.getGroupId());
            if(space_!=null){
                for(String member : space_.getMembers()){
                    receivers.add(member);
                }
            }
        }
        return NotificationInfo.instance()
                .setFrom("support")
                .to(new LinkedList<String>(receivers))
                .with(NotificationUtils.CREATOR, "support")
                .key(getKey()).end();
    }
}
