/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class CSAnnouncementPlugin
extends BaseNotificationPlugin {
    public static final String ID = "CSAnnouncementPlugin";
    public static final ArgumentLiteral<String> PLF_VERSION = new ArgumentLiteral(String.class, "plfVersion");

    public CSAnnouncementPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String plfVersion = (String)ctx.value(PLF_VERSION);
        HashSet<String> receivers = new HashSet<String>();
        CSSpaceService csSpaceService = (CSSpaceService)CommonsUtils.getService(CSSpaceService.class);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        List<SpaceDTO> spaces = csSpaceService.getAllSpaces();
        for (SpaceDTO space : spaces) {
            Space space_ = spaceService.getSpaceByGroupId(space.getGroupId());
            if (space_ == null) continue;
            for (String member : space_.getMembers()) {
                receivers.add(member);
            }
        }
        return NotificationInfo.instance().setFrom("support").to(new LinkedList(receivers)).with("creator", "support").with("plfVersion", plfVersion).key(this.getKey()).end();
    }
}

