/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.integration.notification.NotificationUtils;
import org.exoplatform.cs.integration.notification.TemplateUtils;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="CSReminderPlugin", template="war:/notification/templates/mail/CSReminderPlugin.gtmpl"), @TemplateConfig(pluginId="CSStatusChangedNotificationPlugin", template="war:/notification/templates/mail/CSStatusChangedNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSTicketAssignedNotificationPlugin", template="war:/notification/templates/mail/CSTicketAssignedNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSTicketAssignedToMeNotificationPlugin", template="war:/notification/templates/mail/CSTicketAssignedToMeNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSTicketClosedNotificationPlugin", template="war:/notification/templates/mail/CSTicketClosedNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSSubscriptionExpiredPlugin", template="war:/notification/templates/mail/CSSubscriptionExpiredPlugin.gtmpl"), @TemplateConfig(pluginId="CSSubscriptionReminderPlugin", template="war:/notification/templates/mail/CSSubscriptionReminderPlugin.gtmpl"), @TemplateConfig(pluginId="CSPrivatePostPlugin", template="war:/notification/templates/mail/CSPrivatePostPlugin.gtmpl"), @TemplateConfig(pluginId="CSSLAReminderPlugin", template="war:/notification/templates/mail/CSSLAReminderPlugin.gtmpl"), @TemplateConfig(pluginId="CSAddPostPlugin", template="war:/notification/templates/mail/CSAddPostPlugin.gtmpl"), @TemplateConfig(pluginId="CSRatePlugin", template="war:/notification/templates/mail/CSRatePlugin.gtmpl"), @TemplateConfig(pluginId="CSAnnouncementPlugin", template="war:/notification/templates/mail/CSAnnouncementPlugin.gtmpl"), @TemplateConfig(pluginId="CSSpaceEditionPlugin", template="war:/notification/templates/mail/CSSpaceEditionPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"CSReminderPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSStatusChangedNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSTicketAssignedNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSTicketAssignedToMeNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSTicketClosedNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSubscriptionExpiredPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSubscriptionReminderPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSPrivatePostPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSLAReminderPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSAddPostPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSRatePlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSAnnouncementPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSpaceEditionPlugin"), new TemplateBuilder());
    }

    public static String getExcerpt(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() > len) {
            str = str.substring(0, len);
            int lastSpace = str.lastIndexOf(" ");
            return (lastSpace > 0 ? str.substring(0, lastSpace) : str) + "...";
        }
        return str;
    }

    protected String getDate(String date, String userName) {
        if (date != null) {
            Date date_ = new Date(Long.parseLong(date));
            return TemplateUtils.format(date_, this.getUserTimezone(userName));
        }
        return "";
    }

    public TimeZone getUserTimezone(String username) {
        try {
            CalendarService calService = (CalendarService)CommonsUtils.getService(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception e) {
            log.error((Object)"Can't retrieve timezone", (Throwable)e);
            return null;
        }
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            Identity id;
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            log.info((Object)("Prepare Mail notif for " + notification.getKey().getId()));
            String creator = notification.getValueOwnerParameter("creator");
            String ticketUrl = notification.getValueOwnerParameter("ticketUrl");
            String userName = notification.getValueOwnerParameter("userName");
            String ticketId = notification.getValueOwnerParameter("ticketId");
            String ticketTitle = notification.getValueOwnerParameter("ticketTitle");
            String ticketStatus = notification.getValueOwnerParameter("ticketStatus");
            String rateType = notification.getValueOwnerParameter("rateType");
            String ratedFrom = notification.getValueOwnerParameter("ratedFrom");
            String plfVersion = notification.getValueOwnerParameter("plfVersion");
            String assignee = notification.getValueOwnerParameter("assignee");
            String oldValue = notification.getValueOwnerParameter("oldValue");
            String period = notification.getValueOwnerParameter("period");
            String spaceId = notification.getValueOwnerParameter("spaceId");
            String spaceName = notification.getValueOwnerParameter("spaceTitle");
            String spaceUrl = notification.getValueOwnerParameter("spaceUrl");
            String endDate = notification.getValueOwnerParameter("endDate");
            String post = notification.getValueOwnerParameter("post");
            String days = notification.getValueOwnerParameter("days");
            String hours = notification.getValueOwnerParameter("hours");
            String minutes = notification.getValueOwnerParameter("minutes");
            String actionName = notification.getValueOwnerParameter(NotificationUtils.ACTION_NAME.getKey());
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            if (actionName != null) {
                templateContext.put((Object)"ACTION_NAME", (Object)actionName);
            }
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity author = identityManager.getOrCreateIdentity("organization", creator, true);
            Profile profile = author.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)author.getRemoteId()));
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            if (ticketUrl != null) {
                templateContext.put((Object)"TICKET_URL", (Object)ticketUrl);
            }
            if (userName != null) {
                id = identityManager.getOrCreateIdentity("organization", userName, false);
                templateContext.put((Object)"USER_NAME", (Object)id.getProfile().getFullName());
            }
            if (assignee != null) {
                id = identityManager.getOrCreateIdentity("organization", assignee, false);
                templateContext.put((Object)"ASSIGNEE", (Object)id.getProfile().getFullName());
            }
            if (ticketId != null) {
                templateContext.put((Object)"TICKET_ID", (Object)ticketId);
            }
            if (ticketTitle != null) {
                templateContext.put((Object)"TICKET_TITLE", (Object)ticketTitle);
            }
            if (ticketStatus != null) {
                templateContext.put((Object)"TICKET_STATUS", (Object)ticketStatus);
            }
            if (rateType != null) {
                templateContext.put((Object)"RATE_TYPE", (Object)rateType);
            }
            if (ratedFrom != null) {
                templateContext.put((Object)"RATED_FROM", (Object)ratedFrom);
            }
            if (plfVersion != null) {
                templateContext.put((Object)"PLF_VERSION", (Object)plfVersion);
            }
            if (oldValue != null) {
                templateContext.put((Object)"OLD_VALUE", (Object)oldValue);
            }
            if (period != null) {
                templateContext.put((Object)"PERIOD", (Object)period);
            }
            if (spaceId != null) {
                templateContext.put((Object)"SPACE_ID", (Object)spaceId);
            }
            if (spaceName != null) {
                templateContext.put((Object)"SPACE_NAME", (Object)spaceName);
            }
            if (spaceUrl != null) {
                templateContext.put((Object)"SPACE_URL", (Object)spaceUrl);
            }
            if (endDate != null && !endDate.equals("")) {
                templateContext.put((Object)"END_DATE", (Object)CSUtils.formatDate(endDate, CSUtils.getUserTimezone(notification.getTo())));
            }
            if (post != null) {
                templateContext.put((Object)"POST", (Object)post);
            }
            if (hours != null) {
                templateContext.put((Object)"HOURS", (Object)hours);
            }
            if (days != null) {
                templateContext.put((Object)"DAYS", (Object)days);
            }
            if (minutes != null) {
                templateContext.put((Object)"MINUTES", (Object)minutes);
            }
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = org.exoplatform.commons.notification.template.TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = org.exoplatform.commons.notification.template.TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap<String, LinkedList<NotificationInfo>> map = new HashMap<String, LinkedList<NotificationInfo>>();
            for (NotificationInfo notif : notifications) {
                String activityID = notif.getValueOwnerParameter("activityId");
                LinkedList<NotificationInfo> tmp = (LinkedList<NotificationInfo>)map.get(activityID);
                if (tmp == null) {
                    tmp = new LinkedList<NotificationInfo>();
                    map.put(activityID, tmp);
                }
                tmp.add(notif);
            }
            StringBuilder sb = new StringBuilder();
            for (String activityID : map.keySet()) {
                List notifs = (List)map.get(activityID);
                NotificationInfo first = (NotificationInfo)notifs.get(0);
                String ticketUrl = first.getValueOwnerParameter("ticketUrl");
                if (notifs.size() == 1) {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                } else {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_MORE.getValue());
                }
                sb.append("<li style=\"margin:0 0 13px 14px;font-size:13px;line-height:18px;font-family:HelveticaNeue,Helvetica,Arial,sans-serif\"><div style=\"color: #333;\">");
                String digester = org.exoplatform.commons.notification.template.TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }
    }
}

