/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.dto;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class BrowserDTO
implements Serializable {
    private static final String VERSION_SEPRATOR = "_VERSION_";
    private static final long serialVersionUID = 3229517974267780415L;
    private BrowserType name;
    private String version;
    private boolean selected;

    public BrowserDTO() {
    }

    public BrowserDTO(String combinedName, boolean selected) {
        String[] strings = combinedName.split(VERSION_SEPRATOR);
        this.name = BrowserType.valueOf(strings[0]);
        this.version = strings.length > 1 ? strings[1] : "";
        this.selected = selected;
    }

    public String combinedName() {
        return this.name.name() + (String)(StringUtils.isBlank((CharSequence)this.version) ? "" : VERSION_SEPRATOR + this.version);
    }

    public BrowserType getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setName(BrowserType name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowserDTO)) {
            return false;
        }
        BrowserDTO other = (BrowserDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BrowserType this$name = this.getName();
        BrowserType other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)((Object)this$name)).equals((Object)other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        return this.isSelected() == other.isSelected();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowserDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BrowserType $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)((Object)$name)).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + (this.isSelected() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BrowserDTO(name=" + this.getName() + ", version=" + this.getVersion() + ", selected=" + this.isSelected() + ")";
    }

    public static enum BrowserType {
        FF,
        IE,
        CHROME,
        SAFARI;

    }
}

