/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class CSRatePlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CSRatePlugin.class);
    public static final String ID = "CSRatePlugin";
    public static final ArgumentLiteral<TicketDTO> TICKET = new ArgumentLiteral(TicketDTO.class, "ticket");
    public static final ArgumentLiteral<String> RATER_USERNAME = new ArgumentLiteral(String.class, "raterUsername");
    public static final ArgumentLiteral<Boolean> IS_RATED_FROM_MAIL = new ArgumentLiteral(Boolean.class, "isRatedFromMail");
    SpaceService spaceService;

    public CSRatePlugin(InitParams initParams, SpaceService spaceService) {
        super(initParams);
        this.spaceService = spaceService;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        TicketDTO ticket = (TicketDTO)ctx.value(TICKET);
        Boolean isRatedFromMail = (Boolean)ctx.value(IS_RATED_FROM_MAIL);
        String raterUsername = (String)ctx.value(RATER_USERNAME);
        HashSet<String> receivers = new HashSet<String>();
        List<User> users = CSUtils.getInternalSupportMembers();
        if (users != null && users.size() > 0) {
            for (User user : users) {
                receivers.add(user.getUserName());
            }
        } else if (ticket.getAssignee() != null) {
            receivers.add(ticket.getAssignee());
        }
        StringBuilder activityId = new StringBuilder("support");
        activityId.append("-").append(ticket.getId());
        String ticketUrl = CommonsUtils.getCurrentDomain() + ticket.getLink();
        String ticketId = ticket.getTicketId();
        String ticketTitle = ticket.getTitle();
        Space space = null;
        try {
            space = this.spaceService.getSpaceByGroupId(ticket.getSpaceGroupId());
        }
        catch (Exception e) {
            LOG.error("Could not get Space with th group Id {}", new Object[]{ticket.getSpaceGroupId(), e});
        }
        Boolean rate = ticket.getCustomerSatisfied();
        String rateType = rate != null ? (rate.booleanValue() ? "Good" : "Bad") : "";
        return NotificationInfo.instance().setFrom("support").to(new LinkedList(receivers)).with("creator", raterUsername).with("assignee", ticket.getAssignee()).with("ticketUrl", ticketUrl).with("ticketId", ticketId).with("spaceTitle", space != null ? space.getDisplayName().replaceAll("(?i)^(client|customer)", "").trim() : "Customer").with("ticketTitle", ticketTitle).with("ticketStatus", ticket.getStatus()).with("ratedFrom", isRatedFromMail != false ? "Email" : "Web").with("rateType", rateType).key(this.getKey()).end();
    }
}

