/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.rest.CustomerRateRest;
import org.exoplatform.cs.rest.model.Ticket;
import org.exoplatform.cs.rest.utils.CSRestUtils;
import org.exoplatform.cs.rest.utils.EntityBuilder;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/customer-space/ticket")
@Api(value="/customer-space/ticket", description="Manages ticket information")
public class CustomerTicketRest
implements ResourceContainer {
    private TicketService ticketService;
    private TicketStatusFlowService ticketStatusFlowService;
    private static final String SPACE_GROUP = "/spaces/";
    private static final Log LOG = ExoLogger.getLogger(CustomerRateRest.class);

    public CustomerTicketRest(TicketService ticketService, TicketStatusFlowService ticketStatusFlowService) {
        this.ticketService = ticketService;
        this.ticketStatusFlowService = ticketStatusFlowService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/flowstate/{name}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="retrieves a ticket flow stats", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getFlowStatsByName(@ApiParam(value="Ticket Flow name", required=true) @PathParam(value="name") String name) {
        List<Object> flowStates = new ArrayList();
        try {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                flowStates = this.ticketStatusFlowService.getFlowbyName(name).getStates();
            }
            if (flowStates == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"no flow state found").build();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving ticket flow stats", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok(flowStates).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/info/{ticketId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="retrieves a ticket information", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTicketById(@ApiParam(value="Ticket Id", required=true) @PathParam(value="ticketId") String ticketId) {
        TicketDTO ticketDTO = null;
        try {
            if (ticketId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"ticket Id is mandatory").build();
            }
            ticketDTO = this.ticketService.findById(ticketId);
            if (!CSRestUtils.authorizedOnCS(ticketDTO.getSpaceGroupId())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized").build();
            }
            if (ticketDTO == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"ticket not found").build();
            }
            ticketDTO.setCreatorAvatar(CSRestUtils.getProfile(ticketDTO.getCreatorId()).getAvatarUrl());
            if (StringUtils.isNotBlank((CharSequence)ticketDTO.getAssignee()) && CSRestUtils.getProfile(ticketDTO.getAssignee()) != null) {
                ticketDTO.setAssigneeAvatar(CSRestUtils.getProfile(ticketDTO.getAssignee()).getAvatarUrl());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving ticket information", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)EntityBuilder.fromTicketDto(ticketDTO)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="update an existing ticket information", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateTicket(@ApiParam(value="Ticket Object to update", required=true) Ticket ticket, @ApiParam(value="Ticket new rate to be update", required=false) @QueryParam(value="rate") String rate) {
        if (!CSRestUtils.authorizedOnCS(ticket.getSpaceGroupId())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized").build();
        }
        if (ticket == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid ticket Object input").build();
        }
        if (ticket.getTicketId() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"ticket id is mandatory").build();
        }
        TicketDTO ticketDTO = null;
        try {
            ticketDTO = EntityBuilder.toTicketDto(ticket);
            if (rate != null && rate.equals("update")) {
                this.ticketService.updateTicketSatisfaction(ticketDTO, CSRestUtils.getCurrentUser().getUserName());
                this.ticketService.notifyCustomerRate(ticketDTO, CSRestUtils.getCurrentUser().getUserName(), false);
            } else {
                ticketDTO = this.ticketService.updateTicket(ticketDTO, CSRestUtils.getCurrentUser());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a ticket", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return this.getTicketById(ticketDTO.getId());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="create a new support ticket", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response createTicket(@ApiParam(value="Ticket Object to save", required=true) Ticket ticket) {
        if (ticket == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid ticket Object input").build();
        }
        if (!CSRestUtils.authorizedOnCS(SPACE_GROUP + ticket.getSpaceGroupId())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized").build();
        }
        TicketDTO ticketDTO = null;
        try {
            ticketDTO = EntityBuilder.toTicketDto(ticket);
            ticketDTO.setSpaceGroupId(SPACE_GROUP + ticketDTO.getSpaceGroupId());
            ticketDTO.setFiles(CSRestUtils.getFiles(ticketDTO.getUploads()));
            if (IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
                ticketDTO.setSeverity(IssueSeverity.SEVERITY_4);
            }
            User currentUser = CSRestUtils.getCurrentUser();
            this.ticketService.createTicket(ticketDTO, currentUser, null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving a ticket", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        if (ticketDTO.getType().equals((Object)IssueType.PRODUCT)) {
            return Response.ok((Object)EntityBuilder.fromTicketDto(ticketDTO)).build();
        }
        return this.getTicketById(ticketDTO.getId());
    }
}

