/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.Flow;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.cs.service.util.SpacePageUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.gatein.api.ApiException;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.NavigationImpl;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.security.Group;
import org.gatein.api.site.SiteId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="customerspace")
public class TicketUpdatesService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(TicketUpdatesService.class);
    private static final CacheControl cc;
    private static final String PATTERN = "dd-MM-yyyy HH:mm:ss Z";
    private static final SimpleDateFormat sdf;

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="cstickets/updates.json")
    @Produces(value={"application/json"})
    public Response getUpdates(@Context UriInfo uriInfo, @QueryParam(value="from") String from, @QueryParam(value="to") String to) {
        TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
        LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
        String DATE_FORMAT = "dd-MM-yyyy";
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        try {
            if (from != null && !from.isEmpty()) {
                fromDate.setTime(df.parse(from));
            } else {
                fromDate.add(2, -1);
            }
            if (to != null && !to.isEmpty()) {
                toDate.setTime(df.parse(to));
            }
        }
        catch (ParseException e) {
            LOG.error("Start and End Date format should be {}", new Object[]{DATE_FORMAT});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        List<LogEntity> updates = logDAO.getupdates(fromDate, toDate);
        String response = this.buildJsonArrayOfUpdates(updates);
        return Response.ok((Object)response, (String)"application/json").cacheControl(cc).build();
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="cstickets/getstats")
    @Produces(value={"application/json"})
    public Response getStats(@Context UriInfo uriInfo, @QueryParam(value="internal") Boolean internal) {
        LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
        if (internal == null) {
            internal = false;
        }
        try {
            JSONArray TicketsNumber = new JSONArray();
            List<Object[]> results = logDAO.getLogsGroupdByNewValue(internal);
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = results.get(i);
                JSONObject data = new JSONObject();
                data.put("satatus", (Object)((String)arr[0] != null ? ((String)arr[0]).toString() : "_"));
                data.put("logId", ((BigInteger)arr[1]).longValue());
                data.put("ticketId", ((BigInteger)arr[1]).longValue());
                TicketsNumber.put((Object)data);
            }
            String response = TicketsNumber.toString();
            return Response.ok((Object)response, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @RolesAllowed(value={"administrators"})
    @Path(value="cstickets/getlogs")
    @Produces(value={"application/json"})
    public Response getLogs(@Context UriInfo uriInfo, @QueryParam(value="newvalue") String newValue, @QueryParam(value="type") String type) {
        LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
        try {
            List<LogEntity> updates = null;
            updates = newValue != null ? logDAO.getLogsByNewValue(newValue) : (type != null ? logDAO.getByType(LogType.valueOf(type), 0, 0) : logDAO.findAll());
            String response = this.buildJsonArrayOfUpdates(updates);
            return Response.ok((Object)response, (String)"application/json").cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    @POST
    @Path(value="cstickets/addcreator")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response addCreator(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
            ForumService forumService = TicketUpdatesService.getService(ForumService.class, null);
            OrganizationService organizationService = TicketUpdatesService.getService(OrganizationService.class, null);
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            User user = organizationService.getUserHandler().findUserByName(currentUser);
            List<TicketDTO> tickets = ticketService.getTickets("", true, "");
            for (TicketDTO ticket : tickets) {
                if (ticket.getCreator() != null && !ticket.getCreator().equals("")) continue;
                String topicId = ticket.getId();
                Category spaceCategory = forumService.getCategoryIncludedSpace();
                Forum forum = ForumUtils.getSpaceForum(forumService, ticket.getSpaceGroupId());
                if (spaceCategory == null || forum == null) continue;
                try {
                    Topic topic = forumService.getTopic(spaceCategory.getId(), forum.getId(), topicId, null);
                    ticketService.updateTicketCreator(ticket, topic.getOwner());
                    LOG.info((Object)("Ticket " + ticket.getTitle() + "'s creator set to " + topic.getOwner()));
                }
                catch (Exception e) {
                    LOG.error("Can not get data of Topic {}", new Object[]{topicId});
                }
            }
            return Response.ok((Object)"Tickets Updates").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/addowner")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response addOwner(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
            List<TicketDTO> tickets = ticketService.getTickets("", true, "");
            String owner = "";
            for (TicketDTO ticket : tickets) {
                if (ticket.getOwner() != null && !ticket.getOwner().equals("")) continue;
                try {
                    if (ticket.getStatus().equals("closed")) {
                        ticketService.updateTicketOwner(ticket, Owner.EMPTY);
                        owner = Owner.EMPTY.name();
                    } else if (ticket.getStatus().equals("suspended_wfi") || ticket.getStatus().equals("resolved_wfv")) {
                        ticketService.updateTicketOwner(ticket, Owner.CUSTOMER);
                        owner = Owner.CUSTOMER.name();
                    } else if (ticket.getStatus().equals("resolved_maintenance")) {
                        ticketService.updateTicketOwner(ticket, Owner.MAINTENANCE);
                        owner = Owner.MAINTENANCE.name();
                    } else if (ticket.getStatus().equals("resolved_improvement")) {
                        ticketService.updateTicketOwner(ticket, Owner.PM);
                        owner = Owner.PM.name();
                    } else {
                        ticketService.updateTicketOwner(ticket, Owner.SUPPORT);
                        owner = Owner.SUPPORT.name();
                    }
                    LOG.info((Object)("Ticket " + ticket.getTitle() + "'s owner set to " + owner));
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not update owner");
                }
            }
            return Response.ok((Object)"Tickets Updates").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/updateassignee")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response updateAssignee(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
            Stream users = CSUtils.getSupportMembers().stream();
            List<TicketDTO> tickets = ticketService.getTickets("", true, "");
            for (TicketDTO ticket : tickets) {
                if (ticket.getAssignee() == null) continue;
                try {
                    if (!users.anyMatch(user -> user.getUserName().equals(ticket.getAssignee()))) {
                        ticketService.updateTicketAssignee(ticket, null);
                    }
                    LOG.info((Object)("Ticket " + ticket.getTitle() + "'s assignee changed from " + ticket.getAssignee() + " to null"));
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not update owner");
                }
            }
            return Response.ok((Object)"Tickets Updates").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/updatewarning")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response upadateWarning(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            TicketService ticketService = TicketUpdatesService.getService(TicketService.class, null);
            List<TicketDTO> tickets = ticketService.getTickets("", true, "");
            String owner = "";
            for (TicketDTO ticket : tickets) {
                if (ticket.getStatus().equals("open") && ticket.getStatus().equals("new")) continue;
                try {
                    if (ticket.getFirstWarningDate() != null || ticket.getLastWarningDate() != null) {
                        ticketService.cancelTicketWarning(ticket);
                    }
                    LOG.info((Object)("Ticket " + ticket.getTitle() + "'s warning updated"));
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not update warning");
                }
            }
            return Response.ok((Object)"Tickets Updates").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/updatlog")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response upadatLogs(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TICKET_SEVERITY_CHANGED, 0, 0);
            TicketStatusFlowService ticketStatusFlowService = TicketUpdatesService.getService(TicketStatusFlowService.class, null);
            Map<String, Flow> flows = ticketStatusFlowService.getFlows();
            ArrayList states = new ArrayList();
            flows.forEach((k, v) -> {
                for (FlowState flow : v.getStates()) {
                    states.add(flow.getState());
                }
            });
            for (LogEntity log : logs) {
                if (!states.contains(log.getNewValue())) continue;
                try {
                    log.setType(LogType.TICKET_STATUS_CHANGED);
                    logDAO.update(log);
                    LOG.info((Object)"log type changed");
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not update warning");
                }
            }
            return Response.ok((Object)"Tickets Updates").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/addlogspaces")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response addLogSpaces(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List logs = logDAO.findAll();
            for (LogEntity log : logs) {
                try {
                    if (log.getSpaceId() == null) {
                        log.setSpaceId(log.getTopic().getSpace().getGroupId());
                        logDAO.update(log);
                    }
                    LOG.info((Object)"log space set");
                }
                catch (Exception e) {
                    LOG.error((Object)"Can not update log");
                }
            }
            return Response.ok((Object)"logs Updates").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="csspace/updatenav")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response updatenav(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LOG.info((Object)"=== Start migration of Spaces Navigation");
            long startTime = System.currentTimeMillis();
            CSSpaceService CsSpaceService = TicketUpdatesService.getService(CSSpaceService.class, null);
            SpaceService spaceService = TicketUpdatesService.getService(SpaceService.class, null);
            UserPortalConfigService portalConfigService = TicketUpdatesService.getService(UserPortalConfigService.class, null);
            NavigationService navigationService = TicketUpdatesService.getService(NavigationService.class, null);
            DescriptionService descriptionService = TicketUpdatesService.getService(DescriptionService.class, null);
            ResourceBundleManager bundleManager = TicketUpdatesService.getService(ResourceBundleManager.class, null);
            int i = 1;
            List<SpaceDTO> csspaces = CsSpaceService.getAllSpaces();
            for (SpaceDTO cspace : csspaces) {
                if (cspace.isInternal()) {
                    ++i;
                    continue;
                }
                Space space = spaceService.getSpaceByGroupId(cspace.getGroupId());
                if (space != null) {
                    LOG.info((Object)(i + "/" + csspaces.size() + "----- Start update nav of Space " + space.getDisplayName()));
                    try {
                        portalConfigService.createUserPortalConfig(PortalConfig.GROUP_TYPE, space.getGroupId(), "CSSpace");
                        SiteKey siteKey = SiteKey.group((String)space.getGroupId());
                        Navigation navigation = this.getNav(space, siteKey, navigationService, descriptionService, bundleManager);
                        Node home = navigation.getNode(NodePath.path((String[])new String[]{space.getUrl()}), Nodes.visitAll());
                        Node tempHome = navigation.getNode(NodePath.path((String[])new String[]{"cs"}), Nodes.visitAll());
                        for (Node childNode : tempHome) {
                            if (home.hasChild(childNode.getName())) {
                                if (childNode.getName().equals("guide")) continue;
                                home.removeChild(childNode.getName());
                            }
                            Node newNode = home.addChild(childNode.getName());
                            newNode.setIconName(childNode.getIconName());
                            newNode.setPageId(childNode.getPageId());
                            newNode.setVisibility(childNode.getVisibility());
                            navigation.saveNode(home);
                            navigation.removeNode(childNode.getNodePath());
                            this.convertChildApplicationPreferences(space, siteKey, newNode, portalConfigService);
                        }
                        home.setPageId(tempHome.getPageId());
                        navigation.saveNode(home);
                        this.convertChildApplicationPreferences(space, siteKey, home, portalConfigService);
                        navigation.removeNode(tempHome.getNodePath());
                    }
                    catch (Exception e) {
                        LOG.error((Object)("NewPortalConfig error: " + e.getMessage()), (Throwable)e);
                    }
                }
                LOG.info((Object)("----- Space " + space.getDisplayName() + " Nav updated"));
                ++i;
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("=== Migration of Spaces Navigation is done in " + (endTime - startTime) + " ms"));
            return Response.ok((Object)("Migration of Spaces Navigation is done in " + (endTime - startTime) + " ms")).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private Navigation getNav(Space space, SiteKey siteKey, NavigationService navigationService, DescriptionService descriptionService, ResourceBundleManager bundleManager) {
        try {
            NavigationContext ctx = navigationService.loadNavigation(siteKey);
            if (ctx == null) {
                return null;
            }
            Group group = new Group(space.getGroupId());
            return new NavigationImpl(new SiteId(group), navigationService, ctx, descriptionService, bundleManager);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to load navigation", t);
        }
    }

    @GET
    @Path(value="cstickets/getfirttimelogs")
    @RolesAllowed(value={"administrators"})
    public Response getFirtTimeLogs(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="startdate") long startDate, @QueryParam(value="enddate") long endDate) throws Exception {
        try {
            JSONArray ticketsJSON = new JSONArray();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            List<LogEntity> logs = logDAO.getTimeToFirstResponseBetweenDates(fromDate, toDate, false);
            for (LogEntity log : logs) {
                JSONObject update = new JSONObject();
                update.put("id", (Object)log.getTopic().getId());
                update.put("topicTitle", (Object)log.getTopic().getTitle());
                update.put("updater", (Object)log.getUserID());
                update.put("updateType", (Object)log.getType().name());
                update.put("oldValue", (Object)log.getOriginalValue());
                update.put("newValue", (Object)log.getNewValue());
                update.put("when", (Object)sdf.format(log.getWhen().getTime()));
                update.put("timeToFirstResponse", (Object)log.getTimeToFirstResponse());
                update.put("timeToResolution", (Object)log.getTimeToResolution());
                update.put("spaceId", (Object)log.getSpaceId());
                ticketsJSON.put((Object)update);
            }
            return Response.ok((Object)ticketsJSON.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/getticketstat/{topic}")
    @RolesAllowed(value={"administrators"})
    public Response getTicketStat(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="topic") String topic) throws Exception {
        try {
            JSONArray ticketsJSON = new JSONArray();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getLogsByTicket(topic);
            for (LogEntity log : logs) {
                JSONObject update = new JSONObject();
                update.put("id", (Object)log.getTopic().getId());
                update.put("topicTitle", (Object)log.getTopic().getTitle());
                update.put("updater", (Object)log.getUserID());
                update.put("updateType", (Object)log.getType().name());
                update.put("oldValue", (Object)log.getOriginalValue());
                update.put("newValue", (Object)log.getNewValue());
                update.put("when", (Object)sdf.format(log.getWhen().getTime()));
                update.put("timeToFirstResponse", (Object)log.getTimeToFirstResponse());
                update.put("timeToResolution", (Object)log.getTimeToResolution());
                update.put("spaceId", (Object)log.getSpaceId());
                ticketsJSON.put((Object)update);
            }
            return Response.ok((Object)ticketsJSON.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/getresolutiontimelogs")
    @RolesAllowed(value={"administrators"})
    public Response getResTimeLogs(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="startdate") long startDate, @QueryParam(value="enddate") long endDate) throws Exception {
        try {
            JSONArray ticketsJSON = new JSONArray();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(startDate);
            Calendar toDate = Calendar.getInstance();
            toDate.setTimeInMillis(endDate);
            List<LogEntity> logs = logDAO.getTimeToResolutionBetweenDates(fromDate, toDate, false);
            for (LogEntity log : logs) {
                JSONObject update = new JSONObject();
                update.put("id", (Object)log.getTopic().getId());
                update.put("topicTitle", (Object)log.getTopic().getTitle());
                update.put("updater", (Object)log.getUserID());
                update.put("updateType", (Object)log.getType().name());
                update.put("oldValue", (Object)log.getOriginalValue());
                update.put("newValue", (Object)log.getNewValue());
                update.put("when", (Object)sdf.format(log.getWhen().getTime()));
                update.put("timeToFirstResponse", (Object)log.getTimeToFirstResponse());
                update.put("timeToResolution", (Object)log.getTimeToResolution());
                update.put("spaceId", (Object)log.getSpaceId());
                ticketsJSON.put((Object)update);
            }
            return Response.ok((Object)ticketsJSON.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/getTimeStats")
    @RolesAllowed(value={"administrators"})
    public Response getTimeLogs(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            JSONArray ticketsJSON = new JSONArray();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TIME_TO_RESOLUTION_ADDED, 0, 0);
            List<LogEntity> logs_ = logDAO.getByType(LogType.TIME_TO_FIRST_RESPONSE_ADDED, 0, 0);
            logs.addAll(logs_);
            for (LogEntity log : logs) {
                JSONObject update = new JSONObject();
                update.put("id", (Object)log.getTopic().getId());
                update.put("topicTitle", (Object)log.getTopic().getTitle());
                update.put("updater", (Object)log.getUserID());
                update.put("updateType", (Object)log.getType().name());
                update.put("oldValue", (Object)log.getOriginalValue());
                update.put("newValue", (Object)log.getNewValue());
                update.put("when", (Object)sdf.format(log.getWhen().getTime()));
                update.put("timeToFirstResponse", (Object)log.getTimeToFirstResponse());
                update.put("timeToResolution", (Object)log.getTimeToResolution());
                update.put("spaceId", (Object)log.getSpaceId());
                ticketsJSON.put((Object)update);
            }
            return Response.ok((Object)ticketsJSON.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/updatettr")
    @RolesAllowed(value={"administrators"})
    public Response updateTTR(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LOG.info((Object)"=== Start updating Time To First Response");
            long startTime = System.currentTimeMillis();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            TopicDAO topicDAO = TicketUpdatesService.getService(TopicDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TIME_TO_RESOLUTION_ADDED, 0, 0);
            for (LogEntity log : logs) {
                try {
                    TopicEntity top;
                    LOG.info((Object)("update Topic: " + log.getTopic().getId() + "____Log TTR: " + log.getTimeToResolution() + "____Topic TTR: " + log.getTopic().getTimeToResolution()));
                    if (log.getTopic().getTimeToResolution() == null || log.getTimeToResolution() == null) continue;
                    if (log.getTopic().getTimeToFirstResponse() < 0L) {
                        top = log.getTopic();
                        top.setTimeToResolution(0L);
                        topicDAO.update(top);
                    }
                    if (log.getTimeToFirstResponse() < 0L) {
                        log.setTimeToFirstResponse(0L);
                        logDAO.update(log);
                    }
                    if (log.getTopic().getTimeToFirstResponse() <= log.getTimeToFirstResponse()) continue;
                    top = log.getTopic();
                    top.setTimeToResolution(log.getTimeToFirstResponse());
                    topicDAO.update(top);
                    LOG.error((Object)("updated Topic: " + log.getTopic().getId()));
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot update Topic: " + log.getTopic().getId() + "____Log TTR: " + log.getTimeToResolution() + "____Topic TTR: " + log.getTopic().getTimeToResolution()));
                }
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("=== updating Time To Resolution done in " + (endTime - startTime) + " ms"));
            return Response.ok((Object)("updating Time To First Response is done in " + (endTime - startTime) + " ms")).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/cleanttr")
    @RolesAllowed(value={"administrators"})
    public Response cleanTTR(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LOG.info((Object)"=== Start cleaning Time To First Response");
            long startTime = System.currentTimeMillis();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TIME_TO_RESOLUTION_ADDED, 0, 0);
            for (LogEntity log : logs) {
                try {
                    if (log.getTopic().getTimeToResolution() == null || log.getTimeToResolution() == null || log.getTopic().getTimeToResolution() >= log.getTimeToResolution()) continue;
                    logDAO.delete(log);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot update Topic: " + log.getTopic().getId() + "____Log TFR: " + log.getTimeToResolution() + "____Topic TFR: " + log.getTopic().getTimeToResolution()));
                }
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("=== cleaning Time To Resolution done in " + (endTime - startTime) + " ms"));
            return Response.ok((Object)("cleaning Time To Resolution is done in " + (endTime - startTime) + " ms")).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/updatetfr")
    @RolesAllowed(value={"administrators"})
    public Response updateTFR(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LOG.info((Object)"=== Start updating Time To First Response");
            long startTime = System.currentTimeMillis();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            TopicDAO topicDAO = TicketUpdatesService.getService(TopicDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TIME_TO_FIRST_RESPONSE_ADDED, 0, 0);
            for (LogEntity log : logs) {
                try {
                    TopicEntity top;
                    LOG.info((Object)("update Topic: " + log.getTopic().getId() + "____Log TFR: " + log.getTimeToFirstResponse() + "____Topic TFR: " + log.getTopic().getTimeToFirstResponse()));
                    if (log.getTopic().getTimeToFirstResponse() == null || log.getTimeToFirstResponse() == null) continue;
                    if (log.getTopic().getTimeToFirstResponse() < 0L) {
                        top = log.getTopic();
                        top.setTimeToFirstResponse(0L);
                        topicDAO.update(top);
                    }
                    if (log.getTimeToFirstResponse() < 0L) {
                        log.setTimeToFirstResponse(0L);
                        logDAO.update(log);
                    }
                    if (log.getTopic().getTimeToFirstResponse() <= log.getTimeToFirstResponse()) continue;
                    top = log.getTopic();
                    top.setTimeToFirstResponse(log.getTimeToFirstResponse());
                    topicDAO.update(top);
                    LOG.error((Object)("updated Topic: " + log.getTopic().getId()));
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot update Topic: " + log.getTopic().getId() + "____Log TFR: " + log.getTimeToFirstResponse() + "____Topic TFR: " + log.getTopic().getTimeToFirstResponse()));
                }
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("=== updating Time To First Response done in " + (endTime - startTime) + " ms"));
            return Response.ok((Object)("updating Time To First Response is done in " + (endTime - startTime) + " ms")).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/cleantfr")
    @RolesAllowed(value={"administrators"})
    public Response cleanTFR(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LOG.info((Object)"=== Start cleaning Time To First Response");
            long startTime = System.currentTimeMillis();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            TopicDAO topicDAO = TicketUpdatesService.getService(TopicDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TIME_TO_FIRST_RESPONSE_ADDED, 0, 0);
            for (LogEntity log : logs) {
                try {
                    if (log.getTopic().getTimeToFirstResponse() == null || log.getTimeToFirstResponse() == null || log.getTopic().getTimeToFirstResponse() >= log.getTimeToFirstResponse()) continue;
                    logDAO.delete(log);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot update Topic: " + log.getTopic().getId() + "____Log TFR: " + log.getTimeToFirstResponse() + "____Topic TFR: " + log.getTopic().getTimeToFirstResponse()));
                }
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("=== cleaning Time To First Response done in " + (endTime - startTime) + " ms"));
            return Response.ok((Object)("cleaning Time To First Response is done in " + (endTime - startTime) + " ms")).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="cstickets/getStatusTransitions")
    @RolesAllowed(value={"administrators"})
    public Response getStatusTransitions(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            JSONArray ticketsJSON = new JSONArray();
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TICKET_STATUS_CHANGED, 0, 0);
            for (LogEntity log : logs) {
                JSONObject update = new JSONObject();
                update.put("topicTitle", (Object)log.getTopic().getTitle());
                update.put("transition", (Object)(log.getOriginalValue() + " --> " + log.getNewValue()));
                update.put("updater", (Object)log.getUserID());
                update.put("when", (Object)sdf.format(log.getWhen().getTime()));
                ticketsJSON.put((Object)update);
            }
            return Response.ok((Object)ticketsJSON.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/setTimes")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response setTimes(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LogEntity logEntity;
            TopicEntity topic;
            TopicDAO topicDAO = TicketUpdatesService.getService(TopicDAO.class, null);
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<TopicEntity> tickets = topicDAO.getAllTickets();
            List<String> status = Arrays.asList("resolved_wfv", "resolved_maintenance");
            List<LogEntity> logs = logDAO.getLogsByNewValue("resolved_wfv");
            for (LogEntity log : logs) {
                topic = (TopicEntity)topicDAO.find((Serializable)((Object)log.getTopic().getId()));
                if (topic == null) continue;
                topic.setTimeToResolution(CSUtils.getDiffBetweenTwoDates(topic.getCreationDate(), log.getWhen()));
                topicDAO.update(topic);
                logEntity = new LogEntity(LogType.TIME_TO_RESOLUTION_ADDED, "support", log.getWhen(), "", "", topic, null, topic.getTimeToResolution(), topic.getSpace().getGroupId());
                logDAO.create(logEntity);
                LOG.info((Object)("Ticket " + topic.getTitle() + " TimeToResolution set"));
            }
            logs = logDAO.getLogsByNewValue("resolved_maintenance");
            for (LogEntity log : logs) {
                topic = (TopicEntity)topicDAO.find((Serializable)((Object)log.getTopic().getId()));
                if (topic == null || !"/spaces/exo_tribe_feedback".equals(topic.getSpace().getGroupId())) continue;
                topic.setTimeToResolution(CSUtils.getDiffBetweenTwoDates(topic.getCreationDate(), log.getWhen()));
                topicDAO.update(topic);
                logEntity = new LogEntity(LogType.TIME_TO_RESOLUTION_ADDED, "support", log.getWhen(), "", "", topic, null, topic.getTimeToResolution(), topic.getSpace().getGroupId());
                logDAO.create(logEntity);
                LOG.info((Object)("Ticket " + topic.getTitle() + " TimeToResolution set"));
            }
            logs = logDAO.getLogsByNewValue("considered");
            for (LogEntity log : logs) {
                topic = (TopicEntity)topicDAO.find((Serializable)((Object)log.getTopic().getId()));
                if (topic == null || topic.getSpace().getInternal().booleanValue()) continue;
                topic.setTimeToFirstResponse(CSUtils.getDiffBetweenTwoDates(topic.getCreationDate(), log.getWhen()));
                topicDAO.update(topic);
                logEntity = new LogEntity(LogType.TIME_TO_FIRST_RESPONSE_ADDED, "support", log.getWhen(), "", "", topic, topic.getTimeToFirstResponse(), null, topic.getSpace().getGroupId());
                logDAO.create(logEntity);
                LOG.info((Object)("Ticket " + topic.getTitle() + " TimeToFirstResponse set"));
            }
            return Response.ok((Object)"Tickets Updated").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/addopenlog")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response addOpenLog(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TICKET_CREATED, 0, 0);
            for (LogEntity log : logs) {
                LogEntity logEntity = new LogEntity(LogType.TICKET_STATUS_CHANGED, log.getUserID(), log.getWhen(), "", "open", log.getTopic(), null, null, log.getTopic().getSpace().getGroupId());
                logDAO.create(logEntity);
            }
            LOG.info((Object)"End add open status logs");
            return Response.ok((Object)"Tickets Updated").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cstickets/updatelogstimes")
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    public Response updateLogsTimes(@Context HttpServletRequest request, @Context UriInfo uriInfo) throws Exception {
        try {
            TopicEntity topic;
            TopicDAO topicDAO = TicketUpdatesService.getService(TopicDAO.class, null);
            LogDAO logDAO = TicketUpdatesService.getService(LogDAO.class, null);
            List<LogEntity> logs = logDAO.getByType(LogType.TIME_TO_RESOLUTION_ADDED, 0, 0);
            for (LogEntity log : logs) {
                if (log.getTimeToResolution() != null || (topic = (TopicEntity)topicDAO.find((Serializable)((Object)log.getTopic().getId()))) == null) continue;
                log.setTimeToResolution(topic.getTimeToResolution());
                logDAO.update(log);
                LOG.info((Object)("log for " + topic.getTitle() + " TimeToResolution set"));
            }
            logs = logDAO.getByType(LogType.TIME_TO_FIRST_RESPONSE_ADDED, 0, 0);
            for (LogEntity log : logs) {
                if (log.getTimeToFirstResponse() != null || (topic = (TopicEntity)topicDAO.find((Serializable)((Object)log.getTopic().getId()))) == null) continue;
                log.setTimeToFirstResponse(topic.getTimeToFirstResponse());
                logDAO.update(log);
                LOG.info((Object)("log for " + topic.getTitle() + " TimeToFirstResponse set"));
            }
            return Response.ok((Object)"Logs Updated").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private String buildJsonArrayOfUpdates(List<LogEntity> updatesList) {
        JSONArray ticketsJSON = new JSONArray();
        HashMap<TopicEntity, List> updatesMap = new HashMap<TopicEntity, List>();
        for (LogEntity logEntity : updatesList) {
            updatesMap.computeIfAbsent(logEntity.getTopic(), k -> new ArrayList()).add(logEntity);
        }
        updatesMap.forEach((k, v) -> {
            JSONObject ticketJSON = new JSONObject();
            try {
                ticketJSON.put("ticket", (Object)this.buildJsonObject((TopicEntity)k));
                for (LogEntity entity : v) {
                    JSONObject update = new JSONObject();
                    update.put("id", (Object)entity.getTopic().getId());
                    update.put("topicTitle", (Object)entity.getTopic().getTitle());
                    update.put("updater", (Object)entity.getUserID());
                    update.put("updateType", (Object)entity.getType().name());
                    update.put("oldValue", (Object)entity.getOriginalValue());
                    update.put("newValue", (Object)entity.getNewValue());
                    update.put("when", (Object)sdf.format(entity.getWhen().getTime()));
                    update.put("timeToFirstResponse", (Object)entity.getTimeToFirstResponse());
                    update.put("timeToResolution", (Object)entity.getTimeToResolution());
                    update.put("spaceId", (Object)entity.getSpaceId());
                    ticketJSON.append("updates", (Object)update);
                }
                ticketsJSON.put((Object)ticketJSON);
            }
            catch (Exception e) {
                LOG.error("A problem when building JSON for LogEntity {}", new Object[]{k.getId(), e});
            }
        });
        return ticketsJSON.toString();
    }

    private JSONObject buildJsonObject(TopicEntity topicEntity) {
        JSONObject ticket = new JSONObject();
        try {
            ticket.put("id", (Object)topicEntity.getId());
            ticket.put("assignee", (Object)topicEntity.getAssignee());
            ticket.put("environmentName", (Object)(topicEntity.getEnvironment() != null ? topicEntity.getEnvironment().getName() : ""));
            ticket.put("infoType", (Object)(topicEntity.getInfoType() != null ? topicEntity.getInfoType().name() : ""));
            ticket.put("link", (Object)topicEntity.getLink());
            ticket.put("severity", (Object)(topicEntity.getSeverity() != null ? topicEntity.getSeverity().name() : ""));
            ticket.put("spaceGroupId", (Object)topicEntity.getSpace().getGroupId());
            ticket.put("title", (Object)topicEntity.getTitle());
            ticket.put("type", (Object)(topicEntity.getType() != null ? topicEntity.getType().name() : ""));
            ticket.put("status", (Object)topicEntity.getStatus());
            ticket.put("updateDate", (Object)sdf.format(topicEntity.getUpdateDate().getTime()));
        }
        catch (JSONException jsonException) {
            LOG.error("A problem when building JSON for ticket {}", new Object[]{topicEntity.getId()});
        }
        return ticket;
    }

    private String buildJsonArray(List<TopicEntity> ticketDTOS) {
        JSONArray array = new JSONArray();
        for (TopicEntity ticketDTO : ticketDTOS) {
            JSONObject ticket = this.buildJsonObject(ticketDTO);
            array.put((Object)ticket);
        }
        return array.toString();
    }

    private void convertChildApplicationPreferences(Space space, SiteKey siteKey, Node newNode, UserPortalConfigService portalConfigService) throws Exception {
        PageKey pageKey = new PageKey(siteKey, newNode.getPageId().getPageName());
        Page newPage = CSUtils.getPage(portalConfigService.getDataStorage(), portalConfigService.getPageService(), pageKey);
        ArrayList modelObjects = newPage.getChildren();
        SpacePageUtils.convert(modelObjects, space.getGroupId());
    }

    static {
        sdf = new SimpleDateFormat(PATTERN);
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

