/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.entity;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.cs.entity.ASTypeEntity;
import org.exoplatform.cs.entity.DBTypeEntity;
import org.exoplatform.cs.entity.EnvTypeEntity;
import org.exoplatform.cs.entity.JVMTypeEntity;
import org.exoplatform.cs.entity.OSTypeEntity;
import org.exoplatform.cs.entity.SSOTypeEntity;
import org.exoplatform.cs.entity.SpaceEntity;

@Entity(name="CSEnvironmentEntity")
@ExoEntity
@Table(name="CS_ADDON_ENVIRONMENTS")
@NamedQueries(value={@NamedQuery(name="envEntity.getEnvironmentsBySpace", query="SELECT a FROM CSEnvironmentEntity a where a.space.id = :spaceGroupID"), @NamedQuery(name="envEntity.getAllEnvironments", query="SELECT a FROM CSEnvironmentEntity a order by  a.space.id "), @NamedQuery(name="envEntity.getDefaultEnvironmentsBySpace", query="SELECT a FROM CSEnvironmentEntity a where a.space.id = :spaceGroupID AND DEFAULT_ENVIRONMENT is true")})
public class EnvironmentEntity {
    @Id
    @Column(name="ENVIRONMENT_ID")
    @SequenceGenerator(name="SEQ_CS_ENVIRONMENT_ID", sequenceName="SEQ_CS_ENVIRONMENT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CS_ENVIRONMENT_ID")
    private Long id;
    @Column(name="NAME")
    private String name;
    @Column(name="DEFAULT_ENVIRONMENT")
    private boolean defaultEnvironment;
    @ManyToOne
    @JoinColumn(name="ENV_ID", nullable=false)
    private EnvTypeEntity env;
    @Column(name="PRODUCT_VERSION")
    private String productVersion;
    @ManyToOne
    @JoinColumn(name="OS_ID")
    private OSTypeEntity os;
    @Column(name="OS_VERSION")
    private String osVersion;
    @ManyToOne
    @JoinColumn(name="JVM_ID")
    private JVMTypeEntity jvmVendor;
    @Column(name="JVM_VERSION")
    private String jvmVersion;
    @ManyToOne
    @JoinColumn(name="AS_ID")
    private ASTypeEntity appServer;
    @Column(name="AS_VERSION")
    private String asVersion;
    @ManyToOne
    @JoinColumn(name="DB_ID")
    private DBTypeEntity rdbms;
    @Column(name="DB_VERSION")
    private String dbVersion;
    @Column(name="DB_ENCODING")
    private String dbEncoding;
    @ManyToOne
    @JoinColumn(name="SSO_ID")
    private SSOTypeEntity sso;
    @Column(name="SSO_VERSION")
    private String ssoVersion;
    @Column(name="MORE_INFORMATION")
    private String moreInformation;
    @ElementCollection
    @CollectionTable(name="CS_ADDON_BROWSERS", joinColumns={@JoinColumn(name="ENVIRONMENT_ID")})
    @Column(name="BROWSER")
    private Set<String> browsers = new HashSet<String>();
    @ManyToOne
    @JoinColumn(name="SPACE_ID", nullable=false)
    private SpaceEntity space;
    @Column(name="UPDATEDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar updateDate;
    @Column(name="CUSTOMER_EXTENSION_VERSION")
    private String customerExtensionVersion;
    @Column(name="INSTALLED_PATCH_VERSION")
    private String installedPatchVersion;

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    public EnvTypeEntity getEnv() {
        return this.env;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public OSTypeEntity getOs() {
        return this.os;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public JVMTypeEntity getJvmVendor() {
        return this.jvmVendor;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public ASTypeEntity getAppServer() {
        return this.appServer;
    }

    public String getAsVersion() {
        return this.asVersion;
    }

    public DBTypeEntity getRdbms() {
        return this.rdbms;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getDbEncoding() {
        return this.dbEncoding;
    }

    public SSOTypeEntity getSso() {
        return this.sso;
    }

    public String getSsoVersion() {
        return this.ssoVersion;
    }

    public String getMoreInformation() {
        return this.moreInformation;
    }

    public Set<String> getBrowsers() {
        return this.browsers;
    }

    public SpaceEntity getSpace() {
        return this.space;
    }

    public Calendar getUpdateDate() {
        return this.updateDate;
    }

    public String getCustomerExtensionVersion() {
        return this.customerExtensionVersion;
    }

    public String getInstalledPatchVersion() {
        return this.installedPatchVersion;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultEnvironment(boolean defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public void setEnv(EnvTypeEntity env) {
        this.env = env;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setOs(OSTypeEntity os) {
        this.os = os;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public void setJvmVendor(JVMTypeEntity jvmVendor) {
        this.jvmVendor = jvmVendor;
    }

    public void setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public void setAppServer(ASTypeEntity appServer) {
        this.appServer = appServer;
    }

    public void setAsVersion(String asVersion) {
        this.asVersion = asVersion;
    }

    public void setRdbms(DBTypeEntity rdbms) {
        this.rdbms = rdbms;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public void setDbEncoding(String dbEncoding) {
        this.dbEncoding = dbEncoding;
    }

    public void setSso(SSOTypeEntity sso) {
        this.sso = sso;
    }

    public void setSsoVersion(String ssoVersion) {
        this.ssoVersion = ssoVersion;
    }

    public void setMoreInformation(String moreInformation) {
        this.moreInformation = moreInformation;
    }

    public void setBrowsers(Set<String> browsers) {
        this.browsers = browsers;
    }

    public void setSpace(SpaceEntity space) {
        this.space = space;
    }

    public void setUpdateDate(Calendar updateDate) {
        this.updateDate = updateDate;
    }

    public void setCustomerExtensionVersion(String customerExtensionVersion) {
        this.customerExtensionVersion = customerExtensionVersion;
    }

    public void setInstalledPatchVersion(String installedPatchVersion) {
        this.installedPatchVersion = installedPatchVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvironmentEntity)) {
            return false;
        }
        EnvironmentEntity other = (EnvironmentEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDefaultEnvironment() != other.isDefaultEnvironment()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EnvTypeEntity this$env = this.getEnv();
        EnvTypeEntity other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$productVersion = this.getProductVersion();
        String other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !this$productVersion.equals(other$productVersion)) {
            return false;
        }
        OSTypeEntity this$os = this.getOs();
        OSTypeEntity other$os = other.getOs();
        if (this$os == null ? other$os != null : !((Object)this$os).equals(other$os)) {
            return false;
        }
        String this$osVersion = this.getOsVersion();
        String other$osVersion = other.getOsVersion();
        if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
            return false;
        }
        JVMTypeEntity this$jvmVendor = this.getJvmVendor();
        JVMTypeEntity other$jvmVendor = other.getJvmVendor();
        if (this$jvmVendor == null ? other$jvmVendor != null : !((Object)this$jvmVendor).equals(other$jvmVendor)) {
            return false;
        }
        String this$jvmVersion = this.getJvmVersion();
        String other$jvmVersion = other.getJvmVersion();
        if (this$jvmVersion == null ? other$jvmVersion != null : !this$jvmVersion.equals(other$jvmVersion)) {
            return false;
        }
        ASTypeEntity this$appServer = this.getAppServer();
        ASTypeEntity other$appServer = other.getAppServer();
        if (this$appServer == null ? other$appServer != null : !((Object)this$appServer).equals(other$appServer)) {
            return false;
        }
        String this$asVersion = this.getAsVersion();
        String other$asVersion = other.getAsVersion();
        if (this$asVersion == null ? other$asVersion != null : !this$asVersion.equals(other$asVersion)) {
            return false;
        }
        DBTypeEntity this$rdbms = this.getRdbms();
        DBTypeEntity other$rdbms = other.getRdbms();
        if (this$rdbms == null ? other$rdbms != null : !((Object)this$rdbms).equals(other$rdbms)) {
            return false;
        }
        String this$dbVersion = this.getDbVersion();
        String other$dbVersion = other.getDbVersion();
        if (this$dbVersion == null ? other$dbVersion != null : !this$dbVersion.equals(other$dbVersion)) {
            return false;
        }
        String this$dbEncoding = this.getDbEncoding();
        String other$dbEncoding = other.getDbEncoding();
        if (this$dbEncoding == null ? other$dbEncoding != null : !this$dbEncoding.equals(other$dbEncoding)) {
            return false;
        }
        SSOTypeEntity this$sso = this.getSso();
        SSOTypeEntity other$sso = other.getSso();
        if (this$sso == null ? other$sso != null : !((Object)this$sso).equals(other$sso)) {
            return false;
        }
        String this$ssoVersion = this.getSsoVersion();
        String other$ssoVersion = other.getSsoVersion();
        if (this$ssoVersion == null ? other$ssoVersion != null : !this$ssoVersion.equals(other$ssoVersion)) {
            return false;
        }
        String this$moreInformation = this.getMoreInformation();
        String other$moreInformation = other.getMoreInformation();
        if (this$moreInformation == null ? other$moreInformation != null : !this$moreInformation.equals(other$moreInformation)) {
            return false;
        }
        Set<String> this$browsers = this.getBrowsers();
        Set<String> other$browsers = other.getBrowsers();
        if (this$browsers == null ? other$browsers != null : !((Object)this$browsers).equals(other$browsers)) {
            return false;
        }
        SpaceEntity this$space = this.getSpace();
        SpaceEntity other$space = other.getSpace();
        if (this$space == null ? other$space != null : !((Object)this$space).equals(other$space)) {
            return false;
        }
        Calendar this$updateDate = this.getUpdateDate();
        Calendar other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$customerExtensionVersion = this.getCustomerExtensionVersion();
        String other$customerExtensionVersion = other.getCustomerExtensionVersion();
        if (this$customerExtensionVersion == null ? other$customerExtensionVersion != null : !this$customerExtensionVersion.equals(other$customerExtensionVersion)) {
            return false;
        }
        String this$installedPatchVersion = this.getInstalledPatchVersion();
        String other$installedPatchVersion = other.getInstalledPatchVersion();
        return !(this$installedPatchVersion == null ? other$installedPatchVersion != null : !this$installedPatchVersion.equals(other$installedPatchVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnvironmentEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefaultEnvironment() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EnvTypeEntity $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : $productVersion.hashCode());
        OSTypeEntity $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : ((Object)$os).hashCode());
        String $osVersion = this.getOsVersion();
        result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
        JVMTypeEntity $jvmVendor = this.getJvmVendor();
        result = result * 59 + ($jvmVendor == null ? 43 : ((Object)$jvmVendor).hashCode());
        String $jvmVersion = this.getJvmVersion();
        result = result * 59 + ($jvmVersion == null ? 43 : $jvmVersion.hashCode());
        ASTypeEntity $appServer = this.getAppServer();
        result = result * 59 + ($appServer == null ? 43 : ((Object)$appServer).hashCode());
        String $asVersion = this.getAsVersion();
        result = result * 59 + ($asVersion == null ? 43 : $asVersion.hashCode());
        DBTypeEntity $rdbms = this.getRdbms();
        result = result * 59 + ($rdbms == null ? 43 : ((Object)$rdbms).hashCode());
        String $dbVersion = this.getDbVersion();
        result = result * 59 + ($dbVersion == null ? 43 : $dbVersion.hashCode());
        String $dbEncoding = this.getDbEncoding();
        result = result * 59 + ($dbEncoding == null ? 43 : $dbEncoding.hashCode());
        SSOTypeEntity $sso = this.getSso();
        result = result * 59 + ($sso == null ? 43 : ((Object)$sso).hashCode());
        String $ssoVersion = this.getSsoVersion();
        result = result * 59 + ($ssoVersion == null ? 43 : $ssoVersion.hashCode());
        String $moreInformation = this.getMoreInformation();
        result = result * 59 + ($moreInformation == null ? 43 : $moreInformation.hashCode());
        Set<String> $browsers = this.getBrowsers();
        result = result * 59 + ($browsers == null ? 43 : ((Object)$browsers).hashCode());
        SpaceEntity $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : ((Object)$space).hashCode());
        Calendar $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $customerExtensionVersion = this.getCustomerExtensionVersion();
        result = result * 59 + ($customerExtensionVersion == null ? 43 : $customerExtensionVersion.hashCode());
        String $installedPatchVersion = this.getInstalledPatchVersion();
        result = result * 59 + ($installedPatchVersion == null ? 43 : $installedPatchVersion.hashCode());
        return result;
    }

    public String toString() {
        return "EnvironmentEntity(id=" + this.getId() + ", name=" + this.getName() + ", defaultEnvironment=" + this.isDefaultEnvironment() + ", env=" + this.getEnv() + ", productVersion=" + this.getProductVersion() + ", os=" + this.getOs() + ", osVersion=" + this.getOsVersion() + ", jvmVendor=" + this.getJvmVendor() + ", jvmVersion=" + this.getJvmVersion() + ", appServer=" + this.getAppServer() + ", asVersion=" + this.getAsVersion() + ", rdbms=" + this.getRdbms() + ", dbVersion=" + this.getDbVersion() + ", dbEncoding=" + this.getDbEncoding() + ", sso=" + this.getSso() + ", ssoVersion=" + this.getSsoVersion() + ", moreInformation=" + this.getMoreInformation() + ", browsers=" + this.getBrowsers() + ", space=" + this.getSpace() + ", updateDate=" + this.getUpdateDate() + ", customerExtensionVersion=" + this.getCustomerExtensionVersion() + ", installedPatchVersion=" + this.getInstalledPatchVersion() + ")";
    }
}

