/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.cs.dao.EnvironmentDAO;
import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dao.SpaceDAO;
import org.exoplatform.cs.dao.TopicDAO;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.Owner;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.EnvironmentEntity;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.BaseService;
import org.exoplatform.cs.service.sla.Sla;
import org.exoplatform.cs.service.sla.SlaDelay;
import org.exoplatform.cs.service.sla.SlaService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ProjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketService
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(TicketService.class);
    private TaskService taskService;
    private ForumService forumService;
    private ProjectService projectService;
    private StatusService statusService;
    private ListenerService listenerService;
    private SlaService slaService;
    private LogDAO logDAO;
    private IdentityManager identityManager;
    private static final String DATE_FORMAT_DISPLAYED_IN_TICKETS_LIST = "yyyy-MM-dd HH:mm:ss";
    private static final String TOPIC_DEFAULT_DATE_FORMAT = "EE MMM dd HH:mm:ss z yyyy";
    private static final String TASK_DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat DEFAULT_DATE_FORMAT_USED_FOR_TOPICS = new SimpleDateFormat("EE MMM dd HH:mm:ss z yyyy");
    private static final DateFormat DEFAULT_DATE_FORMAT_USED_FOR_TASKS = new SimpleDateFormat("EE MMM dd HH:mm:ss z yyyy");
    private static final DateFormat DATE_FORMAT_USED_FOR_TASKS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public TicketService(ForumService forumService, ListenerService listenerService, ProjectService projectService, StatusService statusService, TaskService taskService, SlaService slaService, EnvironmentDAO environmentDAO, SpaceDAO spaceDAO, TopicDAO topicDAO, LogDAO logDAO, IdentityManager identityManager) {
        super(environmentDAO, spaceDAO, topicDAO, null);
        this.taskService = taskService;
        this.forumService = forumService;
        this.statusService = statusService;
        this.projectService = projectService;
        this.listenerService = listenerService;
        this.logDAO = logDAO;
        this.identityManager = identityManager;
        this.slaService = slaService;
    }

    public EnvironmentDTO getTopicEnvironment(String topicId) {
        if (StringUtils.isBlank((String)topicId)) {
            throw new IllegalStateException("Parameter 'topicId' is null");
        }
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)topicId));
        if (topicEntity.getEnvironment() == null) {
            return null;
        }
        return this.convert(topicEntity.getEnvironment());
    }

    public List<TicketDTO> getTicketsOfSpace(String id) {
        List<TopicEntity> entities = this.topicDAO.getTopicsBySpace(id, null);
        SpaceEntity space = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)id));
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TopicEntity topicEntity : entities) {
            tickets.add(this.convertToDTO(topicEntity));
        }
        return tickets;
    }

    public List<TicketDTO> getTicketsByEnvironment(Long id) {
        List<TopicEntity> tickets = this.topicDAO.getTopicsByEnvironment(id);
        return this.convertToDTO(tickets);
    }

    public List<TopicEntity> getTicketsEntityByEnvironment(Long id) {
        return this.topicDAO.getTopicsByEnvironment(id);
    }

    public List<TicketDTO> getTickets(String selectedSpace, boolean allTickets, String selectedStatus) {
        List<TopicEntity> entities = allTickets ? (selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getTopicsBySpace(selectedSpace, selectedStatus) : (selectedStatus != null && !selectedStatus.isEmpty() ? this.topicDAO.findByStatus(selectedStatus) : this.topicDAO.getAllTickets())) : (selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getOpenTicketsBySpace(selectedSpace, selectedStatus) : this.topicDAO.getOpenTicketsByStatus(selectedStatus));
        return this.convertToDTO(entities);
    }

    public List<TopicEntity> getAllTickets() {
        return this.topicDAO.getAllTickets();
    }

    public List<TicketDTO> getAssignedTickets(String assignee, String selectedSpace, boolean allTickets, String selectedStatus) {
        List<Object> tickets = new ArrayList();
        tickets = selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getTopicsByAssignee(assignee, selectedSpace, allTickets, selectedStatus) : this.topicDAO.getTopicsByAssignee(assignee, allTickets, selectedStatus);
        return this.convertToDTO(tickets);
    }

    public List<TicketDTO> getMyTickets(String creator, String selectedSpace, boolean allTickets, String selectedStatus) {
        List<Object> tickets = new ArrayList();
        tickets = selectedSpace != null && !selectedSpace.isEmpty() ? this.topicDAO.getTopicsByCreator(creator, selectedSpace, allTickets, selectedStatus) : this.topicDAO.getTopicsByCreator(creator, allTickets, selectedStatus);
        return this.convertToDTO(tickets);
    }

    public String getManagersGroupId(String spaceGroupId) throws Exception {
        SpaceEntity space = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)spaceGroupId));
        return space.getManagersGroupId();
    }

    public SpaceEntity getSpaceByGroupId(String groupID) {
        return (SpaceEntity)this.spaceDAO.find((Serializable)((Object)groupID));
    }

    public TicketDTO updateTicket(TicketDTO ticketDTO, User user) throws Exception {
        HashMap<String, String> changes = new HashMap<String, String>();
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        EnvironmentEntity environment = null;
        ticketDTO.setCreator(topicEntity.getCreator());
        Stream users = CSUtils.getSupportMembers().stream();
        if (ticketDTO.getAssignee() != null && !users.anyMatch(user_ -> user_.getUserName().equals(ticketDTO.getAssignee()))) {
            ticketDTO.setAssignee(null);
        }
        if (ticketDTO.getAssignee() != null && !ticketDTO.getAssignee().equals(topicEntity.getAssignee())) {
            changes.put("ticket.assignee.old", topicEntity.getAssignee());
            changes.put("ticket.assignee.new", ticketDTO.getAssignee());
        }
        if (!IssueType.PRODUCT.equals((Object)ticketDTO.getType())) {
            String oldSeverity = null;
            String oldType = null;
            String oldStatus = null;
            if (!ticketDTO.getSeverity().equals(topicEntity.getSeverity().name())) {
                SpaceEntity space;
                Sla sla;
                if (topicEntity.getLastWarningDate() != null && "open".equals(ticketDTO.getStatus()) && (sla = this.slaService.getSlabyName((space = topicEntity.getSpace()).getSla())) != null) {
                    SlaDelay sDelay = null;
                    for (SlaDelay slaDelay : sla.getSlaDelays()) {
                        if (!slaDelay.getSeverity().equals(ticketDTO.getSeverity().name())) continue;
                        sDelay = slaDelay;
                        break;
                    }
                    if (sDelay != null && sDelay.getUnit().equals("day")) {
                        long delay = sDelay.getDelay() * 24 * 60 * 60 * 1000;
                        ticketDTO.setFirstWarningDate(CSUtils.getNextDate(topicEntity.getCreationDate(), delay * 2L / 3L));
                        ticketDTO.setLastWarningDate(CSUtils.getNextDate(topicEntity.getCreationDate(), delay));
                    }
                    if (sDelay != null && sDelay.getUnit().equals("hour")) {
                        long delay = sDelay.getDelay() * 60 * 60 * 1000;
                        ticketDTO.setFirstWarningDate(CSUtils.getNextDate(topicEntity.getCreationDate(), delay * 2L / 3L));
                        ticketDTO.setLastWarningDate(CSUtils.getNextDate(topicEntity.getCreationDate(), delay));
                    }
                    if (sDelay != null && sDelay.isBusiness()) {
                        Calendar last;
                        Calendar first = ticketDTO.getFirstWarningDate();
                        if (first.get(11) >= 0 && first.get(11) < 9) {
                            first.add(5, -1);
                            first.set(11, 17);
                            ticketDTO.setFirstWarningDate(first);
                        }
                        if (first.get(11) >= 18 && first.get(11) <= 23) {
                            first.set(11, 17);
                            ticketDTO.setFirstWarningDate(first);
                        }
                        if ((last = ticketDTO.getLastWarningDate()).get(11) >= 0 && last.get(11) < 9) {
                            last.set(11, 9);
                            ticketDTO.setLastWarningDate(last);
                        }
                        if (last.get(11) >= 18 && last.get(11) <= 23) {
                            last.add(5, 1);
                            last.set(11, 9);
                            ticketDTO.setLastWarningDate(last);
                        }
                    }
                }
                oldSeverity = topicEntity.getSeverity().name();
                changes.put("ticket.severity.old", oldSeverity);
                changes.put("ticket.severity.new", ticketDTO.getSeverity().name());
            }
            if (!ticketDTO.getType().equals((Object)topicEntity.getType())) {
                oldType = topicEntity.getType().name();
                changes.put("ticket.type.old", oldType);
                changes.put("ticket.type.new", ticketDTO.getType().name());
            }
            if (!ticketDTO.getStatus().equals(topicEntity.getStatus())) {
                oldStatus = topicEntity.getStatus();
                if ("open".equals(topicEntity.getStatus())) {
                    ticketDTO.setFirstWarningDate(null);
                    ticketDTO.setLastWarningDate(null);
                }
                if ("considered".equals(ticketDTO.getStatus())) {
                    ticketDTO.setAssignee(user.getUserName());
                    long timeToFirstResponse = CSUtils.getDiffBetweenTwoDates(topicEntity.getCreationDate(), Calendar.getInstance());
                    ticketDTO.setTimeToFirstResponse(timeToFirstResponse);
                    changes.put("ticket.time.to.first.response", Long.toString(timeToFirstResponse));
                }
                if ("resolved_wfv".equals(ticketDTO.getStatus()) || "resolved_maintenance".equals(ticketDTO.getStatus())) {
                    long timeToResolution = CSUtils.getDiffBetweenTwoDates(topicEntity.getCreationDate(), Calendar.getInstance());
                    ticketDTO.setTimeToResolution(timeToResolution);
                    changes.put("ticket.time.to.resolution", Long.toString(timeToResolution));
                }
                changes.put("ticket.status.old", topicEntity.getStatus());
                changes.put("ticket.status.new", ticketDTO.getStatus());
            }
            if (ticketDTO.getEnvironmentId() != null) {
                environment = (EnvironmentEntity)this.environmentDAO.find(ticketDTO.getEnvironmentId());
            }
        }
        changes.put("user.id", user.getUserName());
        this.convertToEntity(ticketDTO, topicEntity, environment);
        topicEntity.setUpdateDate(Calendar.getInstance());
        this.topicDAO.update(topicEntity);
        this.listenerService.broadcast("exo.addons.cs.ticket.updated", (Object)topicEntity, changes);
        return this.convertToDTO(topicEntity);
    }

    public void updateTicketCreator(TicketDTO ticketDTO, String creator) throws Exception {
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        topicEntity.setCreator(creator);
        this.topicDAO.update(topicEntity);
    }

    public void updateTicketSatisfaction(TicketDTO ticketDTO, String userId) throws Exception {
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        topicEntity.setCustomerSatisfied(ticketDTO.getCustomerSatisfied());
        this.topicDAO.update(topicEntity);
        HashMap<String, String> changes = new HashMap<String, String>();
        changes.put("user.id", userId);
        changes.put("ticket.customer.satisfaction.new", Boolean.toString(ticketDTO.getCustomerSatisfied()));
        this.listenerService.broadcast("exo.addons.cs.ticket.updated", (Object)topicEntity, changes);
    }

    public void updateTicketOwner(TicketDTO ticketDTO, Owner owner) throws Exception {
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        topicEntity.setOwner(owner);
        this.topicDAO.update(topicEntity);
    }

    public void updateTicketAssignee(TicketDTO ticketDTO, String assignee) throws Exception {
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        topicEntity.setAssignee(assignee);
        this.topicDAO.update(topicEntity);
    }

    public void cancelTicketWarning(TicketDTO ticketDTO) throws Exception {
        TopicEntity topicEntity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketDTO.getId()));
        topicEntity.setFirstWarningDate(null);
        topicEntity.setLastWarningDate(null);
        this.topicDAO.update(topicEntity);
    }

    public void updateTicketLink(TicketDTO ticket, String link) {
        TopicEntity entity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticket.getId()));
        entity.setLink(link);
        this.topicDAO.update(entity);
    }

    @ExoTransactional
    public void createTicket(TicketDTO ticketDTO, User user, String spaceLink) throws Exception {
        if (user == null) {
            throw new IllegalArgumentException("Method saveUser - argument user is null");
        }
        String email = user.getEmail();
        if (StringUtils.isBlank((String)email)) {
            throw new IllegalArgumentException("Method saveUser - argument user.email is null");
        }
        if (ticketDTO == null) {
            throw new IllegalArgumentException("Method saveUser - argument ticketDTO is null");
        }
        if (!ticketDTO.verifySaveConditions()) {
            throw new IllegalArgumentException("Method saveUser - argument ticketDTO is not conform: " + ticketDTO);
        }
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)ticketDTO.getSpaceGroupId()));
        if (spaceEntity == null) {
            throw new IllegalStateException("Method saveUser - Space is not found");
        }
        Date currentDate = CommonUtils.getGreenwichMeanTime().getTime();
        long tagIndex = spaceEntity.getTagIndex();
        TopicEntity topicEntity = new TopicEntity();
        if (IssueType.PRODUCT.equals((Object)ticketDTO.getType())) {
            Task task = new Task();
            task.setDescription(ticketDTO.getDescription());
            task.setTitle(ticketDTO.getTitle());
            task.setAssignee(spaceEntity.getTaskDefaultAssignee());
            ticketDTO.setAssignee(spaceEntity.getTaskDefaultAssignee());
            task.setCreatedBy(user.getUserName());
            task.setPriority(spaceEntity.getTaskPriority());
            task.setCreatedTime(currentDate);
            Date startDate = ticketDTO.retrieveFormattedStartDate();
            task.setStartDate(startDate);
            Date endDate = ticketDTO.retrieveFormattedEndDate();
            task.setEndDate(endDate);
            task.setDueDate(endDate);
            Status status = this.getSpaceProjectStatus(ticketDTO.getSpaceGroupId(), user.getUserName());
            task.setStatus(status);
            task = this.taskService.createTask(task);
            ticketDTO.setId("" + task.getId());
            String ticketDateTask = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TASKS, task.getCreatedTime().toString());
            ticketDTO.setStartDate(ticketDateTask);
            String space = ForumUtils.getSpaceForum(this.forumService, spaceEntity.getGroupId()).getForumName();
            String SpaceName = SpaceUtils.cleanString((String)space);
            String taskLink = "/portal/g/:spaces:" + SpaceName + "/" + SpaceName + "/tasks" + "/taskDetail/" + task.getId();
            ticketDTO.setLink(taskLink);
            this.convertToEntity(ticketDTO, topicEntity, null);
            this.topicDAO.create(topicEntity);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("user.id", user.getUserName());
            this.listenerService.broadcast("exo.addons.cs.ticket.created", (Object)topicEntity, data);
        } else if (IssueType.INCIDENT.equals((Object)ticketDTO.getType()) || IssueType.INFORMATION.equals((Object)ticketDTO.getType())) {
            String link;
            Category spaceCategory;
            Topic newTopic = new Topic();
            newTopic.setTopicName(HTMLSanitizer.sanitize((String)("[" + spaceEntity.getTagPrefix() + "-" + tagIndex + "] " + ticketDTO.getTitle())));
            List<FileItem> files = ticketDTO.getFiles();
            if (files != null && !files.isEmpty()) {
                ArrayList<1> forumAttachments = new ArrayList<1>();
                for (final FileItem fileItem : files) {
                    BufferAttachment attachment = new BufferAttachment(){
                        private static final long serialVersionUID = 1221108176051647731L;

                        public InputStream getInputStream() throws Exception {
                            return fileItem.getInputStream();
                        }
                    };
                    attachment.setName(fileItem.getName());
                    attachment.setMimeType(fileItem.getContentType());
                    forumAttachments.add(attachment);
                }
                newTopic.setAttachments(forumAttachments);
            }
            if ((spaceCategory = this.forumService.getCategoryIncludedSpace()) == null) {
                throw new IllegalStateException("Cannot find Forum Spaces category.");
            }
            String groupId = spaceEntity.getGroupId();
            Forum spaceForum = ForumUtils.getSpaceForum(this.forumService, groupId);
            if (spaceLink != null && !spaceLink.isEmpty()) {
                link = spaceLink + "/forum/topic/" + newTopic.getId();
            } else {
                link = ForumUtils.createdForumLink(ForumUtils.TOPIC, newTopic.getId(), false);
                link = link.replace("/ticket", "/forum");
            }
            ticketDTO.setLink(link);
            ticketDTO.setStatus("open");
            newTopic.setModifiedBy(user.getUserName());
            newTopic.setModifiedDate(currentDate);
            String message = HTMLSanitizer.sanitize((String)ticketDTO.getDescription());
            newTopic.setDescription(message);
            newTopic.setLink(link);
            newTopic.setIsNotifyWhenAddPost(email);
            newTopic.setIsWaiting(false);
            newTopic.setIsClosed(false);
            newTopic.setIsLock(false);
            newTopic.setIsModeratePost(false);
            newTopic.setIsSticky(false);
            newTopic.setIcon("");
            newTopic.setOwner(user.getUserName());
            this.forumService.saveTopic(spaceCategory.getId(), spaceForum.getId(), newTopic, true, false, new MessageBuilder());
            EnvironmentEntity environmentEntity = null;
            if (ticketDTO.getType().equals((Object)IssueType.INCIDENT)) {
                environmentEntity = (EnvironmentEntity)this.environmentDAO.find(ticketDTO.getEnvironmentId());
                if (environmentEntity == null) {
                    throw new IllegalStateException("Environment with id '" + ticketDTO.getEnvironmentId() + "' is null");
                }
                if (environmentEntity.getSpace() == null) {
                    throw new IllegalStateException("Environment's space is null");
                }
            }
            spaceEntity.setTagIndex(tagIndex + 1L);
            this.spaceDAO.update(spaceEntity);
            ticketDTO.setId(newTopic.getId());
            ticketDTO.setLink(newTopic.getLink());
            ticketDTO.setTitle(newTopic.getTopicName());
            ticketDTO.setCreator(user.getUserName());
            ticketDTO.setTicketId(spaceEntity.getTagPrefix() + "-" + tagIndex);
            ticketDTO.setStartDate(newTopic.getCreatedDate().toString());
            ticketDTO.setOwner(Owner.EMPTY);
            Sla sla = this.slaService.getSlabyName(spaceEntity.getSla());
            if (sla != null) {
                SlaDelay sDelay = null;
                for (SlaDelay slaDelay : sla.getSlaDelays()) {
                    if (!slaDelay.getSeverity().equals(ticketDTO.getSeverity().name())) continue;
                    sDelay = slaDelay;
                    break;
                }
                if (sDelay != null && sDelay.getUnit().equals("day")) {
                    long delay = sDelay.getDelay() * 24 * 60 * 60 * 1000;
                    ticketDTO.setFirstWarningDate(CSUtils.getNextDate(Calendar.getInstance(), delay * 2L / 3L));
                    ticketDTO.setLastWarningDate(CSUtils.getNextDate(Calendar.getInstance(), delay));
                }
                if (sDelay != null && sDelay.getUnit().equals("hour")) {
                    long delay = sDelay.getDelay() * 60 * 60 * 1000;
                    ticketDTO.setFirstWarningDate(CSUtils.getNextDate(Calendar.getInstance(), delay * 2L / 3L));
                    ticketDTO.setLastWarningDate(CSUtils.getNextDate(Calendar.getInstance(), delay));
                }
                if (sDelay != null && sDelay.isBusiness()) {
                    Calendar last;
                    Calendar first = ticketDTO.getFirstWarningDate();
                    if (first.get(11) >= 0 && first.get(11) < 9) {
                        first.add(5, -1);
                        first.set(11, 17);
                        ticketDTO.setFirstWarningDate(first);
                    }
                    if (first.get(11) >= 18 && first.get(11) <= 23) {
                        first.set(11, 17);
                        ticketDTO.setFirstWarningDate(first);
                    }
                    if ((last = ticketDTO.getLastWarningDate()).get(11) >= 0 && last.get(11) < 9) {
                        last.set(11, 9);
                        ticketDTO.setLastWarningDate(last);
                    }
                    if (last.get(11) >= 18 && last.get(11) <= 23) {
                        last.add(5, 1);
                        last.set(11, 9);
                        ticketDTO.setLastWarningDate(last);
                    }
                }
            }
            this.convertToEntity(ticketDTO, topicEntity, environmentEntity);
            this.topicDAO.create(topicEntity);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("user.id", user.getUserName());
            this.listenerService.broadcast("exo.addons.cs.ticket.created", (Object)topicEntity, data);
        } else {
            throw new UnsupportedOperationException("Method saveUser - argument ticketDTO.type is not recognized");
        }
    }

    private Status getSpaceProjectStatus(String spaceGroupId, String username) {
        Long spaceProjectId = null;
        if (spaceGroupId != null) {
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree((String)spaceGroupId, (ProjectService)this.projectService), (ProjectService)this.projectService);
            for (Project p : projects) {
                if (!p.canView(new Identity(username))) continue;
                spaceProjectId = p.getId();
            }
        }
        if (spaceProjectId == null) {
            throw new IllegalStateException("Can't fin adequate tasks project for space: " + spaceGroupId);
        }
        Status status = this.statusService.getDefaultStatus(spaceProjectId.longValue());
        return status;
    }

    private void convertToEntity(TicketDTO ticketDTO, TopicEntity topicEntity, EnvironmentEntity environmentEntity) throws Exception {
        topicEntity.setId(ticketDTO.getId());
        topicEntity.setTicketId(ticketDTO.getTicketId());
        topicEntity.setEnvironment(environmentEntity);
        SpaceEntity spaceEntity = (SpaceEntity)this.spaceDAO.find((Serializable)((Object)ticketDTO.getSpaceGroupId()));
        topicEntity.setSpace(spaceEntity);
        topicEntity.setType(ticketDTO.getType());
        topicEntity.setSeverity(ticketDTO.getSeverity());
        topicEntity.setInfoType(ticketDTO.getInfoType());
        topicEntity.setLink(ticketDTO.getLink());
        topicEntity.setAssignee(ticketDTO.getAssignee());
        topicEntity.setOwner(ticketDTO.getOwner());
        topicEntity.setStatus(ticketDTO.getStatus());
        topicEntity.setAttachedJira(ticketDTO.getAttachedJira());
        topicEntity.setUpdateDate(this.convertToCalendar(ticketDTO.getUpdateDate()));
        topicEntity.setCreationDate(this.convertToCalendar(ticketDTO.getStartDate()));
        topicEntity.setTitle(ticketDTO.getTitle());
        topicEntity.setCreator(ticketDTO.getCreator());
        topicEntity.setFirstWarningDate(ticketDTO.getFirstWarningDate());
        topicEntity.setLastWarningDate(ticketDTO.getLastWarningDate());
        topicEntity.setTimeToFirstResponse(ticketDTO.getTimeToFirstResponse());
        topicEntity.setTimeToResolution(ticketDTO.getTimeToResolution());
        topicEntity.setCustomerSatisfied(ticketDTO.getCustomerSatisfied());
    }

    private TicketDTO convertToDTO(TopicEntity topicEntity) {
        try {
            TicketDTO ticketDTO = new TicketDTO();
            ticketDTO.setId(topicEntity.getId());
            ticketDTO.setTicketId(topicEntity.getTicketId());
            ticketDTO.setEnvironmentName(topicEntity.getEnvironment() == null ? null : topicEntity.getEnvironment().getName());
            ticketDTO.setSeverity(topicEntity.getSeverity());
            ticketDTO.setInfoType(topicEntity.getInfoType());
            ticketDTO.setLink(topicEntity.getLink());
            ticketDTO.setType(topicEntity.getType());
            ticketDTO.setAssignee(topicEntity.getAssignee());
            ticketDTO.setOwner(topicEntity.getOwner());
            ticketDTO.setAttachedJira(topicEntity.getAttachedJira());
            ticketDTO.setSpaceGroupId(topicEntity.getSpace().getGroupId());
            ticketDTO.setFirstWarningDate(topicEntity.getFirstWarningDate());
            ticketDTO.setLastWarningDate(topicEntity.getLastWarningDate());
            ticketDTO.setLastWarningDate(topicEntity.getLastWarningDate());
            if (topicEntity.getUpdateDate() != null) {
                String updateDate = topicEntity.getUpdateDate().getTime().toString();
                String formattedUpdateDate = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TOPICS, updateDate);
                ticketDTO.setUpdateDate(formattedUpdateDate);
            }
            if (topicEntity.getTitle() != null && !topicEntity.getTitle().isEmpty()) {
                ticketDTO.setTitle(topicEntity.getTitle());
            }
            if (topicEntity.getCreationDate() != null) {
                String startDate = topicEntity.getCreationDate().getTime().toString();
                String ticketDate = this.convertDate(DEFAULT_DATE_FORMAT_USED_FOR_TOPICS, startDate);
                ticketDTO.setStartDate(ticketDate);
            }
            ticketDTO.setStatus(topicEntity.getStatus());
            switch (topicEntity.getType()) {
                case INFORMATION: {
                    ticketDTO.setFlow(topicEntity.getSpace().getInformationFlow());
                }
                case INCIDENT: {
                    ticketDTO.setFlow(topicEntity.getSpace().getIncidentFlow());
                    ticketDTO.setEnvironmentId(topicEntity.getEnvironment() == null ? null : topicEntity.getEnvironment().getId());
                    break;
                }
                case PRODUCT: {
                    long taskId = Long.parseLong(topicEntity.getId());
                    Task task = null;
                    try {
                        task = this.taskService.getTask(taskId);
                    }
                    catch (EntityNotFoundException e) {
                        LOG.warn("Task with id '{}' was not found", (Object)topicEntity.getId());
                    }
                    if (task == null) break;
                    if (topicEntity.getCreationDate() != null) {
                        String ticketDateTask = DEFAULT_DATE_FORMAT_USED_FOR_TASKS.format(topicEntity.getCreationDate().getTime());
                        ticketDTO.setStartDate(ticketDateTask);
                    }
                    ticketDTO.setStatus(task.getStatus() == null ? "inprogress" : task.getStatus().getName());
                    break;
                }
            }
            ticketDTO.setCreatorId(topicEntity.getCreator());
            if (topicEntity.getCreator() != null) {
                try {
                    ticketDTO.setCreator(this.identityManager.getOrCreateIdentity("organization", topicEntity.getCreator(), false).getProfile().getFullName());
                }
                catch (Exception e) {
                    ticketDTO.setCreator("");
                }
            } else {
                ticketDTO.setCreator("");
            }
            Calendar now = Calendar.getInstance();
            if (topicEntity.getFirstWarningDate() != null && now.after(topicEntity.getFirstWarningDate())) {
                ticketDTO.setWarning("firstWarning");
            }
            if (topicEntity.getLastWarningDate() != null && now.after(topicEntity.getLastWarningDate())) {
                ticketDTO.setWarning("lastWarning");
            }
            ticketDTO.setTimeToFirstResponse(topicEntity.getTimeToFirstResponse());
            ticketDTO.setTimeToResolution(topicEntity.getTimeToResolution());
            ticketDTO.setCustomerSatisfied(topicEntity.getCustomerSatisfied());
            ticketDTO.setInternal(topicEntity.getSpace().getInternal());
            return ticketDTO;
        }
        catch (Exception e) {
            LOG.error("error converting ticket {} from space of group {}", new Object[]{topicEntity.getId(), topicEntity.getSpace().getGroupId(), e});
            return null;
        }
    }

    private List<TicketDTO> convertToDTO(List<TopicEntity> entities) {
        ArrayList<TicketDTO> tickets = new ArrayList<TicketDTO>();
        for (TopicEntity topicEntity : entities) {
            SpaceEntity space = topicEntity.getSpace();
            String groupId = space.getGroupId();
            TicketDTO ticket = this.convertToDTO(topicEntity);
            if (ticket == null) continue;
            tickets.add(ticket);
        }
        return tickets;
    }

    private String convertDate(DateFormat dateFormat, String startDate) {
        Date date = null;
        try {
            date = dateFormat.parse(startDate);
        }
        catch (ParseException e) {
            LOG.error("Error when parsing date", (Throwable)e);
        }
        if (date != null) {
            return DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS.format(date);
        }
        return null;
    }

    private Calendar convertToCalendar(String dateToFormat) {
        Calendar cal = Calendar.getInstance();
        try {
            Date date = DATE_FORMAT_TO_CONVERT_USED_FOR_TICKETS.parse(dateToFormat);
            cal.setTime(date);
        }
        catch (Exception e) {
            LOG.debug("Error when converting {} to a date using formatter {} ", (Object)dateToFormat, (Object)DATE_FORMAT_DISPLAYED_IN_TICKETS_LIST);
        }
        return cal;
    }

    public void deleteTicket(TicketDTO ticket) {
        TopicEntity entity = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticket.getId()));
        if (IssueType.PRODUCT == entity.getType()) {
            try {
                this.taskService.removeTask(Long.parseLong(entity.getId()));
            }
            catch (EntityNotFoundException e) {
                LOG.error("Task {} was not found, ticket entry will be deleted!", (Object)(entity.getId() != null ? entity.getId() : ""));
            }
        } else {
            try {
                Category spaceCategory = this.forumService.getCategoryIncludedSpace();
                String groupId = entity.getSpace().getGroupId();
                Forum spaceForum = ForumUtils.getSpaceForum(this.forumService, groupId);
                this.forumService.removeTopic(spaceCategory.getId(), spaceForum.getId(), entity.getId());
            }
            catch (Exception e) {
                LOG.error("Topic {} could not be removed or is not found, ticket entry will be deleted!", (Object)(entity.getId() != null ? entity.getId() : ""));
            }
        }
        this.topicDAO.delete(entity);
    }

    public List<TicketDTO> getTickets(Calendar fromDate, Calendar toDate) {
        List<TopicEntity> tickets = this.topicDAO.findUpdatedBetween(fromDate, toDate);
        return this.convertToDTO(tickets);
    }

    public List<TicketDTO> getUpdatedTickets(String status, String space, Calendar fromDate, Calendar toDate) {
        List<Object> tickets = new ArrayList();
        tickets = this.isEmpty(space) && this.isEmpty(status) ? this.topicDAO.findUpdatedBetween(fromDate, toDate) : (this.isEmpty(space) && !this.isEmpty(status) ? this.topicDAO.getUpdatedTicketsByStatus(status, fromDate, toDate) : (!this.isEmpty(space) && this.isEmpty(status) ? this.topicDAO.getUpdatedTicketsBySpace(space, fromDate, toDate) : this.topicDAO.getUpdatedTicketsBySpaceAndStatus(space, status, fromDate, toDate)));
        return this.convertToDTO(tickets);
    }

    public List<TicketDTO> getCreatedTickets(String space, Calendar fromDate, Calendar toDate) {
        List<Object> tickets = new ArrayList();
        tickets = !this.isEmpty(space) ? this.topicDAO.getCreatedTicketsBySpace(space, fromDate, toDate) : this.topicDAO.getCreatedTickets(fromDate, toDate);
        return this.convertToDTO(tickets);
    }

    public List<TicketDTO> getNotAssignedTickets(String space) {
        List<Object> tickets = new ArrayList();
        tickets = !this.isEmpty(space) ? this.topicDAO.getNotAssignedTicketsBySpace(space) : this.topicDAO.getNotAssignedTickets();
        return this.convertToDTO(tickets);
    }

    public List<TopicEntity> findTicketsForReminder(Calendar toDate) {
        return this.topicDAO.findTicketsForReminder(toDate);
    }

    public List<TopicEntity> findAllTickets() {
        return this.topicDAO.getAllTickets();
    }

    public Long getTicketsCount(SpaceEntity space, IssueType type) {
        return this.topicDAO.countTickets(space, type);
    }

    public List<LogEntity> getUpdatedTickets(Calendar from, Calendar to) {
        return this.logDAO.getupdates(from, to);
    }

    public TicketDTO findById(String ticketId) {
        TopicEntity ticket = (TopicEntity)this.topicDAO.find((Serializable)((Object)ticketId));
        return this.convertToDTO(ticket);
    }

    public TicketDTO findByTicketId(String ticketId) {
        return this.convertToDTO(this.topicDAO.findByTicketId(ticketId));
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public List<Object[]> countCustomerTicketsGroupdBySpace(boolean internal) {
        return this.topicDAO.countCustomerTicketsGroupdBySpace(internal);
    }

    public List<Object[]> countCustomerTicketsGroupdByOwner(boolean internal) {
        return this.topicDAO.countCustomerTicketsGroupdByOwner(internal);
    }

    public List<Object[]> countCustomerTicketsGroupdByStatus(boolean internal) {
        return this.topicDAO.countCustomerTicketsGroupdByStatus(internal);
    }

    public Long getCustomerOpenTicketsCount(boolean internal) {
        return this.topicDAO.countOpenCustomerTickets(internal);
    }

    public Long getCustomerClosedTicketsCount(boolean internal) {
        return this.topicDAO.countClosedCustomerTickets(internal);
    }

    public Long getCustomerOpenTicketsCountByDates(boolean internal, Calendar from, Calendar to) {
        return this.topicDAO.countOpenCustomerTicketsByDates(internal, from, to);
    }

    public Long getCustomerClosedTicketsCountByDates(boolean internal, Calendar from, Calendar to) {
        return this.topicDAO.countClosedCustomerTicketsByDates(internal, from, to);
    }

    public List<Object[]> countCustomerTicketsGroupdByStatusAndDates(boolean internal, Calendar from, Calendar to) {
        return this.topicDAO.countCustomerTicketsGroupdByStatusAndDates(internal, from, to);
    }

    public Long countSatisfiedTicketNumber(boolean internal) {
        return this.topicDAO.countSatisfiedTicketNumber(internal);
    }

    public Long countNotSatisfiedTicketNumber(boolean internal) {
        return this.topicDAO.countNotSatisfiedTicketNumber(internal);
    }

    public Double getTimeToFirstResponseAvg(boolean internal) {
        return this.topicDAO.getTimeToFirstResponseAvg(internal);
    }

    public Double getTimeToResolutionAvg(boolean internal) {
        return this.topicDAO.getTimeToResolutionAvg(internal);
    }

    public List<Object[]> countSpaceTicketsGroupdByStatus(String space) {
        return this.topicDAO.countSpaceTicketsGroupdByStatus(space);
    }

    public List<Object[]> countSpaceTicketsGroupdByOwner(String space) {
        return this.topicDAO.countSpaceTicketsGroupdByOwner(space);
    }

    public List<Object[]> countSpaceTicketsGroupdByAssignee(String space) {
        return this.topicDAO.countSpaceTicketsGroupdByAssignee(space);
    }

    public List<Object[]> countCustomerTicketsGroupdByAssigneeAndDates(boolean internal, Calendar from, Calendar to) {
        return this.topicDAO.countCustomerTicketsGroupdByAssigneeAndDates(internal, from, to);
    }

    public List<Object[]> countCustomerTicketsGroupdByAssigne(boolean internal) {
        return this.topicDAO.countCustomerTicketsGroupdByAssignee(internal);
    }

    public List<Object[]> countCustomerTicketsGroupdBySeverityAndDates(boolean internal, Calendar from, Calendar to) {
        return this.topicDAO.countCustomerTicketsGroupdBySeverityAndDates(internal, from, to);
    }

    public List<Object[]> countCustomerTicketsGroupdBySeverity(boolean internal) {
        return this.topicDAO.countCustomerTicketsGroupdBySeverity(internal);
    }

    public Long countSpaceSatisfiedTicketNumber(String space) {
        return this.topicDAO.countSpaceSatisfiedTicketNumber(space);
    }

    public Long countSpaceNotSatisfiedTicketNumber(String space) {
        return this.topicDAO.countSpaceNotSatisfiedTicketNumber(space);
    }

    public Double getSpaceTimeToFirstResponseAvg(String space) {
        return this.topicDAO.getSpaceTimeToFirstResponseAvg(space);
    }

    public Double getSpaceTimeToResolutionAvg(String space) {
        return this.topicDAO.getSpaceTimeToResolutionAvg(space);
    }
}

