/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.cs.dao.StatLogDAO;
import org.exoplatform.cs.dto.StatLogDTO;
import org.exoplatform.cs.entity.StatLogEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class StatsService {
    private static final Log LOG = ExoLogger.getLogger(StatsService.class);
    private StatLogDAO statLogDAO = new StatLogDAO();

    public StatLogEntity save(StatLogEntity entity) {
        try {
            if (entity == null) {
                throw new IllegalStateException("Parameter 'entity' is null");
            }
            return (StatLogEntity)this.statLogDAO.create(entity);
        }
        catch (IllegalStateException e) {
            LOG.error("Cannot save the stat", new Object[]{e.getMessage()});
            return null;
        }
    }

    public List<StatLogDTO> getStatsByTypeAndDate(String type, Calendar statDate) {
        ArrayList<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
        List<Object> entities = new ArrayList();
        try {
            entities = this.statLogDAO.getStatsByTypeAndDate(type, statDate);
            for (StatLogEntity statLogEntity : entities) {
                dtos.add(this.convert(statLogEntity));
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get stats", new Object[]{e.getMessage()});
        }
        return dtos;
    }

    public List<StatLogDTO> getAllStatsByType(String type, Calendar startDate, Calendar endDate) {
        ArrayList<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
        List<Object> entities = new ArrayList();
        try {
            entities = startDate == null || endDate == null ? this.statLogDAO.getAllStatsByType(type) : this.statLogDAO.getAllStatsByTypeAndDates(type, startDate, endDate);
            for (StatLogEntity statLogEntity : entities) {
                dtos.add(this.convert(statLogEntity));
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get stats", new Object[]{e.getMessage()});
        }
        return dtos;
    }

    public List<StatLogDTO> getWeeklyStatsByType(String type, Calendar startDate, Calendar endDate) {
        ArrayList<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
        List<Object> entities = new ArrayList();
        try {
            entities = startDate == null || endDate == null ? this.statLogDAO.getWeeklyStatsByType(type) : this.statLogDAO.getWeeklyStatsByTypeAndDates(type, startDate, endDate);
            for (StatLogEntity statLogEntity : entities) {
                dtos.add(this.convert(statLogEntity));
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get stats", new Object[]{e.getMessage()});
        }
        return dtos;
    }

    public List<StatLogDTO> getMonthlyStatsByType(String type, Calendar startDate, Calendar endDate) {
        ArrayList<StatLogDTO> dtos = new ArrayList<StatLogDTO>();
        List<Object> entities = new ArrayList();
        try {
            entities = startDate == null || endDate == null ? this.statLogDAO.getMonthlyStatsByType(type) : this.statLogDAO.getMonthlyStatsByTypeAndDates(type, startDate, endDate);
            for (StatLogEntity statLogEntity : entities) {
                dtos.add(this.convert(statLogEntity));
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get stats", new Object[]{e.getMessage()});
        }
        return dtos;
    }

    private StatLogEntity convert(StatLogDTO dto) {
        StatLogEntity entity = new StatLogEntity();
        entity.setId(dto.getId());
        entity.setStatDate(dto.getStatDate());
        entity.setStatType(dto.getStatType());
        entity.setStatus(dto.getStatus());
        entity.setTicketsNumber(dto.getTicketsNumber());
        entity.setWeekly(dto.getWeekly());
        entity.setMonthly(dto.getMonthly());
        entity.setSpaceId(dto.getSpaceId());
        return entity;
    }

    private StatLogDTO convert(StatLogEntity entity) {
        StatLogDTO dto = new StatLogDTO();
        dto.setId(entity.getId());
        dto.setStatDate(entity.getStatDate());
        dto.setStatType(entity.getStatType());
        dto.setStatus(entity.getStatus());
        dto.setTicketsNumber(entity.getTicketsNumber());
        dto.setWeekly(entity.getWeekly());
        dto.setMonthly(entity.getMonthly());
        dto.setSpaceId(entity.getSpaceId());
        return dto;
    }
}

