/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.manager.IdentityManager;

public class CSSLAReminderPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CSSLAReminderPlugin.class);
    public static final String ID = "CSSLAReminderPlugin";
    public static final ArgumentLiteral<TopicEntity> TICKET = new ArgumentLiteral(TopicEntity.class, "ticket");
    public static final ArgumentLiteral<String> DAYS = new ArgumentLiteral(String.class, "days");
    public static final ArgumentLiteral<String> HOURS = new ArgumentLiteral(String.class, "hours");
    public static final ArgumentLiteral<String> MINUTES = new ArgumentLiteral(String.class, "minutes");
    IdentityManager identityManager;

    public CSSLAReminderPlugin(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        TopicEntity ticket = (TopicEntity)ctx.value(TICKET);
        HashSet<String> receivers = new HashSet<String>();
        try {
            List<User> users = CSUtils.getSupportMembers();
            for (User user : users) {
                receivers.add(user.getUserName());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot get the list of support mrmbers");
        }
        StringBuilder activityId = new StringBuilder("support");
        activityId.append("-").append(ticket.getId());
        String ticketUrl = CommonsUtils.getCurrentDomain() + ticket.getLink();
        String days = (String)ctx.value(DAYS);
        String hours = (String)ctx.value(HOURS);
        String minutes = (String)ctx.value(MINUTES);
        String ticketId = ticket.getTicketId();
        String ticketTitle = ticket.getTitle();
        return NotificationInfo.instance().setFrom("support").to(new LinkedList(receivers)).with("creator", "support").with("userName", ticket.getAssignee()).with("ticketUrl", ticketUrl).with("activityId", activityId.toString()).with("ticketId", ticketId).with("ticketTitle", ticketTitle).with("days", days).with("hours", hours).with("minutes", minutes).with("ticketStatus", ticket.getStatus()).key(this.getKey()).end();
    }
}

