/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.integration.notification;

import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.integration.notification.MailTemplateProvider;
import org.exoplatform.cs.integration.notification.NotificationUtils;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="CSReminderPlugin", template="war:/notification/templates/web/CSReminderPlugin.gtmpl"), @TemplateConfig(pluginId="CSStatusChangedNotificationPlugin", template="war:/notification/templates/web/CSStatusChangedNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSTicketAssignedNotificationPlugin", template="war:/notification/templates/web/CSTicketAssignedNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSTicketAssignedToMeNotificationPlugin", template="war:/notification/templates/web/CSTicketAssignedToMeNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSTicketClosedNotificationPlugin", template="war:/notification/templates/web/CSTicketClosedNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="CSSubscriptionExpiredPlugin", template="war:/notification/templates/web/CSSubscriptionExpiredPlugin.gtmpl"), @TemplateConfig(pluginId="CSSubscriptionReminderPlugin", template="war:/notification/templates/web/CSSubscriptionReminderPlugin.gtmpl"), @TemplateConfig(pluginId="CSPrivatePostPlugin", template="war:/notification/templates/web/CSPrivatePostPlugin.gtmpl"), @TemplateConfig(pluginId="CSSLAReminderPlugin", template="war:/notification/templates/web/CSSLAReminderPlugin.gtmpl"), @TemplateConfig(pluginId="CSAddPostPlugin", template="war:/notification/templates/web/CSAddPostPlugin.gtmpl"), @TemplateConfig(pluginId="CSRatePlugin", template="war:/notification/templates/web/CSRatePlugin.gtmpl"), @TemplateConfig(pluginId="CSAnnouncementPlugin", template="war:/notification/templates/web/CSAnnouncementPlugin.gtmpl"), @TemplateConfig(pluginId="CSSpaceEditionPlugin", template="war:/notification/templates/web/CSSpaceEditionPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"CSReminderPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSStatusChangedNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSTicketAssignedNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSTicketAssignedToMeNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSTicketClosedNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSubscriptionExpiredPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSubscriptionReminderPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSPrivatePostPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSLAReminderPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSAddPostPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSRatePlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSAnnouncementPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CSSpaceEditionPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            Identity id;
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String creator = notification.getValueOwnerParameter("creator");
            String ticketUrl = notification.getValueOwnerParameter("ticketUrl");
            String userName = notification.getValueOwnerParameter("userName");
            String ticketId = notification.getValueOwnerParameter("ticketId");
            String ticketTitle = notification.getValueOwnerParameter("ticketTitle");
            String ticketStatus = notification.getValueOwnerParameter("ticketStatus");
            String rateType = notification.getValueOwnerParameter("rateType");
            String ratedFrom = notification.getValueOwnerParameter("ratedFrom");
            String assignee = notification.getValueOwnerParameter("assignee");
            String oldValue = notification.getValueOwnerParameter("oldValue");
            String period = notification.getValueOwnerParameter("period");
            String spaceId = notification.getValueOwnerParameter("spaceId");
            String spaceName = notification.getValueOwnerParameter("spaceTitle");
            String spaceUrl = notification.getValueOwnerParameter("spaceUrl");
            String endDate = notification.getValueOwnerParameter("endDate");
            String post = notification.getValueOwnerParameter("post");
            String days = notification.getValueOwnerParameter("days");
            String hours = notification.getValueOwnerParameter("hours");
            String minutes = notification.getValueOwnerParameter("minutes");
            String actionName = notification.getValueOwnerParameter(NotificationUtils.ACTION_NAME.getKey());
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            if (actionName != null) {
                templateContext.put((Object)"ACTION_NAME", (Object)actionName);
            }
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", creator, true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName().toString()));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
            if (ticketUrl != null) {
                templateContext.put((Object)"TICKET_URL", (Object)ticketUrl);
            }
            if (userName != null) {
                id = identityManager.getOrCreateIdentity("organization", userName, false);
                templateContext.put((Object)"USER_NAME", (Object)id.getProfile().getFullName());
            }
            if (ticketId != null) {
                templateContext.put((Object)"TICKET_ID", (Object)ticketId);
            }
            if (ticketTitle != null) {
                templateContext.put((Object)"TICKET_TITLE", (Object)ticketTitle);
            }
            if (ticketStatus != null) {
                templateContext.put((Object)"TICKET_STATUS", (Object)ticketStatus);
            }
            if (rateType != null) {
                templateContext.put((Object)"RATE_TYPE", (Object)rateType);
            }
            if (ratedFrom != null) {
                templateContext.put((Object)"RATED_FROM", (Object)ratedFrom);
            }
            if (assignee != null) {
                id = identityManager.getOrCreateIdentity("organization", assignee, false);
                templateContext.put((Object)"ASSIGNEE", (Object)id.getProfile().getFullName());
            }
            if (oldValue != null) {
                templateContext.put((Object)"OLD_VALUE", (Object)oldValue);
            }
            if (period != null) {
                templateContext.put((Object)"PERIOD", (Object)period);
            }
            if (spaceId != null) {
                templateContext.put((Object)"SPACE_ID", (Object)spaceId);
            }
            if (spaceName != null) {
                templateContext.put((Object)"SPACE_NAME", (Object)spaceName);
            }
            if (spaceUrl != null) {
                templateContext.put((Object)"SPACE_URL", (Object)spaceUrl);
            }
            if (endDate != null && !endDate.equals("")) {
                templateContext.put((Object)"END_DATE", (Object)CSUtils.formatDate(endDate, CSUtils.getUserTimezone(notification.getTo())));
            }
            if (post != null) {
                templateContext.put((Object)"POST", (Object)post);
            }
            if (hours != null) {
                templateContext.put((Object)"HOURS", (Object)hours);
            }
            if (days != null) {
                templateContext.put((Object)"DAYS", (Object)days);
            }
            if (minutes != null) {
                templateContext.put((Object)"MINUTES", (Object)minutes);
            }
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

