/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.entity;

import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="CSStatLogEntity")
@ExoEntity
@Table(name="CS_ADDON_STAT_LOG")
@NamedQueries(value={@NamedQuery(name="statLogEntity.getAllStatsByType", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType group by a.statDate"), @NamedQuery(name="statLogEntity.getWeeklyStatsByType", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.weekly = true group by a.statDate"), @NamedQuery(name="statLogEntity.getMonthlyStatsByType", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.monthly = true group by a.statDate"), @NamedQuery(name="statLogEntity.getStatsByTypeAndDate", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType  AND a.statDate = :statDate"), @NamedQuery(name="statLogEntity.getAllStatsByTypeAndDates", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.statDate >= :from AND a.statDate <= :to"), @NamedQuery(name="statLogEntity.getWeeklyStatsByTypeAndDates", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.weekly = true AND a.statDate >= :from AND a.statDate <= :to"), @NamedQuery(name="statLogEntity.getMonthlyStatsByTypeAndDates", query="SELECT a FROM CSStatLogEntity a where a.statType = :statType AND a.monthly = true AND a.statDate >= :from AND a.statDate <= :to")})
public class StatLogEntity {
    @Id
    @Column(name="STAT_LOG_ID")
    @SequenceGenerator(name="SEQ_CS_STAT_LOG_ID", sequenceName="SEQ_CS_STAT_LOG_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CS_STAT_LOG_ID")
    private Long id;
    @Column(name="STAT_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar statDate;
    @Column(name="STAT_TYPE")
    private String statType;
    @Column(name="STATUS")
    private String status;
    @Column(name="TICKETS_NUMBER")
    private Long ticketsNumber;
    @Column(name="WEEKLY")
    private Boolean weekly;
    @Column(name="MONTHLY")
    private Boolean monthly;
    @Column(name="SPACE_ID")
    private String spaceId;

    public StatLogEntity(Long id, Calendar statDate, String statType, String status, Long ticketsNumber, Boolean weekly, Boolean monthly, String spaceId) {
        this.id = id;
        this.statDate = statDate;
        this.statType = statType;
        this.status = status;
        this.ticketsNumber = ticketsNumber;
        this.weekly = weekly;
        this.monthly = monthly;
        this.spaceId = spaceId;
    }

    public StatLogEntity() {
    }

    public Long getId() {
        return this.id;
    }

    public Calendar getStatDate() {
        return this.statDate;
    }

    public String getStatType() {
        return this.statType;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getTicketsNumber() {
        return this.ticketsNumber;
    }

    public Boolean getWeekly() {
        return this.weekly;
    }

    public Boolean getMonthly() {
        return this.monthly;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setStatDate(Calendar statDate) {
        this.statDate = statDate;
    }

    public void setStatType(String statType) {
        this.statType = statType;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTicketsNumber(Long ticketsNumber) {
        this.ticketsNumber = ticketsNumber;
    }

    public void setWeekly(Boolean weekly) {
        this.weekly = weekly;
    }

    public void setMonthly(Boolean monthly) {
        this.monthly = monthly;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatLogEntity)) {
            return false;
        }
        StatLogEntity other = (StatLogEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$ticketsNumber = this.getTicketsNumber();
        Long other$ticketsNumber = other.getTicketsNumber();
        if (this$ticketsNumber == null ? other$ticketsNumber != null : !((Object)this$ticketsNumber).equals(other$ticketsNumber)) {
            return false;
        }
        Boolean this$weekly = this.getWeekly();
        Boolean other$weekly = other.getWeekly();
        if (this$weekly == null ? other$weekly != null : !((Object)this$weekly).equals(other$weekly)) {
            return false;
        }
        Boolean this$monthly = this.getMonthly();
        Boolean other$monthly = other.getMonthly();
        if (this$monthly == null ? other$monthly != null : !((Object)this$monthly).equals(other$monthly)) {
            return false;
        }
        Calendar this$statDate = this.getStatDate();
        Calendar other$statDate = other.getStatDate();
        if (this$statDate == null ? other$statDate != null : !((Object)this$statDate).equals(other$statDate)) {
            return false;
        }
        String this$statType = this.getStatType();
        String other$statType = other.getStatType();
        if (this$statType == null ? other$statType != null : !this$statType.equals(other$statType)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatLogEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $ticketsNumber = this.getTicketsNumber();
        result = result * 59 + ($ticketsNumber == null ? 43 : ((Object)$ticketsNumber).hashCode());
        Boolean $weekly = this.getWeekly();
        result = result * 59 + ($weekly == null ? 43 : ((Object)$weekly).hashCode());
        Boolean $monthly = this.getMonthly();
        result = result * 59 + ($monthly == null ? 43 : ((Object)$monthly).hashCode());
        Calendar $statDate = this.getStatDate();
        result = result * 59 + ($statDate == null ? 43 : ((Object)$statDate).hashCode());
        String $statType = this.getStatType();
        result = result * 59 + ($statType == null ? 43 : $statType.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "StatLogEntity(id=" + this.getId() + ", statDate=" + this.getStatDate() + ", statType=" + this.getStatType() + ", status=" + this.getStatus() + ", ticketsNumber=" + this.getTicketsNumber() + ", weekly=" + this.getWeekly() + ", monthly=" + this.getMonthly() + ", spaceId=" + this.getSpaceId() + ")";
    }
}

