package org.exoplatform.cs.service.listener;

import java.util.Calendar;
import java.util.Map;


import org.exoplatform.cs.dao.LogDAO;
import org.exoplatform.cs.dto.LogType;
import org.exoplatform.cs.entity.LogEntity;
import org.exoplatform.cs.entity.TopicEntity;
import org.exoplatform.cs.service.CSConstants;
import org.exoplatform.cs.service.util.ForumUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/**
 * Created by IntelliJ IDEA.
 * User: ali
 * Date: 09/01/17
 * Time: 16:59
 */
public class TicketCreatedLogListener extends Listener<TopicEntity, Map<String,String>>{
  private static final Log LOG = ExoLogger.getLogger(TicketCreatedLogListener.class);

  private LogDAO logDAO;
  private ForumService forumService;
  public TicketCreatedLogListener(LogDAO logDAO, ForumService forumService) {
    this.logDAO = logDAO;
    this.forumService = forumService;
  }

  @Override
  public void onEvent(Event<TopicEntity, Map<String, String>> event) throws Exception {
    TopicEntity ticket = event.getSource();
    Map<String,String> data = event.getData();
    String userID = data.get(CSConstants.USERID);
    Calendar now = Calendar.getInstance();
    LogEntity logEntity = new LogEntity(LogType.TICKET_CREATED,userID,now,null,null,ticket);
    logDAO.create(logEntity);
    String message = new StringBuilder().append("Dear customer,").append("<br/>")
            .append("<p>Thank you for contacting eXo support team, we will take care of your request and will contact you soon.</p>")
            .append("<br/>")
            .append("Best regards")
            .append("<br/>")
            .append("eXo Helpdesk").toString();
    ForumUtils.postMessageToTicket(forumService,ticket,message);
    LOG.info("Ticket {} was created by {}",ticket.getId(),userID);
  }
}
