/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.dto;

import java.io.Serializable;

import lombok.Data;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
@Data
public class BrowserDTO implements Serializable {
  private static final String VERSION_SEPRATOR = "_VERSION_";

  private static final long   serialVersionUID = 3229517974267780415L;

  public BrowserDTO() {
  }

  public BrowserDTO(String combinedName, boolean selected) {
    String[] strings = combinedName.split(VERSION_SEPRATOR);
    name = BrowserType.valueOf(strings[0]);
    version = strings.length > 1 ? strings[1] : "";
    this.selected = selected;
  }

  private BrowserType  name;

  private String  version;

  private boolean selected;

  public String combinedName() {
    return name.name() + (StringUtils.isBlank(version) ? "" : (VERSION_SEPRATOR + version));
  }

  public static enum BrowserType {
    FF, IE, CHROME, SAFARI;
  }
}
