/*
 * Copyright (C) 2003-2016 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.cs.dao;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.cs.entity.EnvironmentEntity;

/**
 * Created by The eXo Platform SAS
 * 
 * @author boubaker.khanfir@exoplatform.com
 * @since Apr 27, 2016
 */
public class EnvironmentDAO extends GenericDAOJPAImpl<EnvironmentEntity, Long> {
  private static final Logger LOG = LoggerFactory.getLogger(EnvironmentDAO.class);

  public List<EnvironmentEntity> getEnvironmentsBySpace(String spaceGroupId) throws Exception{
      return getEntityManager().createNamedQuery("envEntity.getEnvironmentsBySpace", EnvironmentEntity.class)
                               .setParameter("spaceGroupID", spaceGroupId)
                               .getResultList();
  }
  
  public EnvironmentEntity getDefaultEnvironmentBySpace(String spaceGroupId) throws Exception{
    EnvironmentEntity environmentEntity;
    environmentEntity =  getEntityManager().createNamedQuery("envEntity.getDefaultEnvironmentsBySpace", EnvironmentEntity.class)
          .setParameter("spaceGroupID", spaceGroupId)
          .getSingleResult();
    return environmentEntity;
  }
}
