package org.exoplatform.cs.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import org.apache.commons.lang3.StringUtils;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BasicEntityDTO {

  public BasicEntityDTO(String id, String value) {
    this.id = id;
    this.value = value;
  }

  String id;

  String name;

  String avatar;

  String type;

  String value;

  public String computeId() {
    if (!StringUtils.isBlank(id)) {
      id = id.replace("@", "");
    }
    return id;
  }
}
