package org.exoplatform.cs.dto;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.task.domain.Priority;

import java.util.Set;

@Data
public class SpaceDTO {

  private String              name;

  private String              description;

  private String              groupId;

  private String              url;

  private BasicEntityDTO      taskDefaultAssignee;

  private String              tagPrefix;

  private BasicEntityDTO      managersGroupId;

  private BasicEntityDTO      invitedMembersGroupId;

  private Set<BasicEntityDTO> members;

  private long                tagIndex     = 1;

  private Priority            taskPriority = Priority.NORMAL;

  private String              owner;

  private long                limitTicketsNumber;

  private long                supportTickets;

  private long                productTickets;

  private long                totalTickets;

  private String              incidentFlow;

  private String              informationFlow;

  private String language;

  private boolean hosted;

  private String sla;

  public boolean verifySaveConditions() {
    if (taskPriority == null || StringUtils.isBlank(name) || StringUtils.isBlank(tagPrefix) || taskDefaultAssignee == null
        || StringUtils.isBlank(taskDefaultAssignee.computeId())) {
      return false;
    }
    return true;
  }
}
