package org.exoplatform.cs.rest.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.exoplatform.cs.dto.InfoType;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.Owner;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


@Data
@AllArgsConstructor
@NoArgsConstructor
public class Ticket implements Cloneable, Serializable {

    // ticket topic id
    private String id;
    private String title;
    private String status;
    private String description;
    private String link;
    private String assignee;
    private String assigneeAvatar;
    private String tagName;
    private IssueType type;
    private IssueSeverity severity;
    private InfoType infoType;
    private String spaceGroupId;
    private String environmentName;
    private Long environmentId;
    private String startDate;
    //private Calendar endDate;
    //private Calendar updateDate;
    private String flow;
    private String ticketId;
    private String creator;
    private String creatorId;
    private String creatorAvatar;
    private Owner owner;
    private String attachedJira;
    //private Calendar firstWarningDate;
    //private Calendar lastWarningDate;
    //private Calendar autoAssignDate;
    private String warning;
    private String jiraStatus;
    private String jiraStatusIcon;
    private Long timeToFirstResponse;
    private Long timeToResolution;
    private Boolean customerSatisfied;
    private Boolean internal;
    private Boolean active;
    private String reason;
    private String rateReason;
    private String[] uploads;
    private List<String> availableTypes;
    private List<String> availableOwners;
    private List<String> availableSeverities;
    private Map<String, String> attachedTasksWithStatus;

    public Ticket clone() {
        return new Ticket(id, title, status, description, link, assignee, assigneeAvatar, tagName, type, severity,
                infoType, spaceGroupId, environmentName, environmentId, startDate,
                flow, ticketId, creator, creatorId, creatorAvatar, owner,
                attachedJira, warning, jiraStatus,
                jiraStatusIcon, timeToFirstResponse, timeToResolution, customerSatisfied, internal,
                active, reason, rateReason, uploads, availableTypes, availableSeverities, availableOwners,
                attachedTasksWithStatus);
    }
}
