package org.exoplatform.cs.service.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.integration.notification.*;
import org.exoplatform.cs.service.CSConstants;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

import org.exoplatform.services.security.ConversationState;


import java.util.Map;


@Asynchronous
public class CSSpaceUpdatedLogListener extends Listener<SpaceDTO, Map<String, String>> {

    @Override
    public void onEvent(Event<SpaceDTO, Map<String, String>> event) throws Exception {
        SpaceDTO spaceDTO = event.getSource();
        Map<String, String> changes = event.getData();
        String actioName = changes.get(CSConstants.ACTION_NAME);

        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(CSSpaceEditionPlugin.SPACE, spaceDTO).append(NotificationUtils.ACTION_NAME, actioName);
        String creator = ConversationState.getCurrent().getIdentity().getUserId();
        ctx.append(NotificationUtils.CREATOR_NAME, creator);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(CSSpaceEditionPlugin.ID))).execute(ctx);
    }
}
