import TicketMenu from './components/TicketMenu.vue';
import CSEnvironment from './components/CSEnvironment.vue';
import CSTicketRate from './components/CSTicketRate.vue';

import * as ticketService from '../services/TicketService.js';
import * as csInfoService from '../services/CSInfoService.js';
import * as csService from '../services/CSService.js';
import * as csUtils from '../services/Utils.js';


const components = {
  'ticket-menu': TicketMenu,
  'cs-environment': CSEnvironment,
  'cs-ticket-rate': CSTicketRate
};

for (const key in components) {
  Vue.component(key, components[key]);
}

if (!Vue.prototype.$ticketService) {
  window.Object.defineProperty(Vue.prototype, '$ticketService', {
    value: ticketService,
  });
}
if (!Vue.prototype.$csInfoService) {
  window.Object.defineProperty(Vue.prototype, '$csInfoService', {
    value: csInfoService,
  });
}
if (!Vue.prototype.$csService) {
  window.Object.defineProperty(Vue.prototype, '$csService', {
    value: csService,
  });
}
if (!Vue.prototype.$csUtils) {
  window.Object.defineProperty(Vue.prototype, '$csUtils', {
    value: csUtils,
  });
}