import TicketMenu from './components/TicketMenu.vue';
import CSEnvironment from './components/CSEnvironment.vue';
import CSTicketRate from './components/CSTicketRate.vue';
import StickyMiniTicketMenu from './components/StickyMiniTicketMenu.vue';
import TicketAttachedTasks from './components/ticketMenuComponents/TicketAttachedTasks.vue';
import TicketSeverities from './components/ticketMenuComponents/TicketSeverities.vue';
import TicketStatuses from './components/ticketMenuComponents/TicketStatuses.vue';
import TicketEditModeAction from './components/TicketEditModeAction.vue';
import TicketStatusReason from './components/ticketMenuComponents/TicketStatusReason.vue';
import TicketQuickAccessActions from './components/ticketMenuComponents/TicketQuickAccessActions.vue';


import * as csInfoService from '../services/CSInfoService.js';

const components = {
  'cs-ticket-menu': TicketMenu,
  'cs-environment': CSEnvironment,
  'cs-ticket-rate': CSTicketRate,
  'cs-sticky-mini-ticket-menu': StickyMiniTicketMenu,
  'cs-ticket-attached-tasks': TicketAttachedTasks,
  'cs-ticket-severities': TicketSeverities,
  'cs-ticket-statuses': TicketStatuses,
  'cs-ticket-edit-mode-action': TicketEditModeAction,
  'cs-ticket-status-reason': TicketStatusReason,
  'cs-ticket-quick-access-actions': TicketQuickAccessActions
};

for (const key in components) {
  Vue.component(key, components[key]);
}

if (!Vue.prototype.$csInfoService) {
  window.Object.defineProperty(Vue.prototype, '$csInfoService', {
    value: csInfoService,
  });
}
