const path = require('path');

let config = {
  context: path.resolve(__dirname, '.'),
  // set the entry point of the application
  // can use multiple entry
  entry: {
    ticketMenu: './src/main/webapp/vue-app/ticketMenu/main.js',
    ticketFeedback: './src/main/webapp/vue-app/ticketFeedback/main.js',
    csCommons: './src/main/webapp/vue-app/commons/main.js',
    csExtensions: './src/main/webapp/vue-app/csExtensions/main.js'
  },
  output: {
    filename: 'js/[name].bundle.js',
    libraryTarget: 'amd'
  },
  externals: {
    vue: 'Vue',
    vuetify: 'Vuetify',
    jquery: '$',
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: [
          'babel-loader',
          'eslint-loader',
        ]
      },
      {
        test: /\.vue$/,
        use: [
          'vue-loader',
          'eslint-loader',
        ]
      }
    ]
  },
};

module.exports = config;