package org.exoplatform.cs.portlet.ticketAdministration;

import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

import javax.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Created by exo on 8/3/16.
 */
public class TicketAdministrationController extends CSControllerBase {
  private static Log  LOG = ExoLogger.getLogger(TicketAdministrationController.class);

  @Inject
  TicketService       ticketService;

  @Inject
  OrganizationService organizationService;

  @Inject
  @Path("index.gtmpl")
  Template            indexTmpl;

  @View
  public Response.Content index() {
    return indexTmpl.ok();
  }

  @Ajax
  @Resource
  @MimeType.JSON
  @Jackson
  public List<TicketDTO> getAllTickets() {
    try {
      List<TicketDTO> tickets = ticketService.getTickets();
      return tickets;
    } catch (Throwable e) {
      LOG.error("Exception when retrieving tickets" + e);
      return null;
    }
  }

  @Ajax
  @Resource
  @MimeType.JSON
  @Jackson
  public Response getBundle(String locale) {
    return super.getBundle(new Locale(locale));
  }

  @Ajax
  @Resource(method = HttpMethod.POST)
  @MimeType.JSON
  @Jackson
  public TicketDTO saveTicket(@Jackson TicketDTO ticketDTO) throws Exception {
    try {
      String groupID = ticketDTO.getSpaceGroupId();
      SpaceEntity spaceEntity = ticketService.getSpaceByGroupId(groupID);
      return ticketService.UpdateTicketDTO(ticketDTO, spaceEntity);
    } catch (Exception e) {
      LOG.error("Error when updating ticket", e);
      throw e;
    }
  }

  @Ajax
  @Resource(method = HttpMethod.POST)
  @MimeType.JSON
  @Jackson
  public List<String> getEngSupportsUsernames(@Jackson TicketDTO ticketDTO) {
    try {
      String spaceGroupId = ticketDTO.getSpaceGroupId();
      String groupId = ticketService.getManagersGroupId(spaceGroupId);
      ListAccess<User> EngSupportList = organizationService.getUserHandler().findUsersByGroupId(groupId);
      User[] users = EngSupportList.load(0, EngSupportList.getSize() < 30 ? EngSupportList.getSize() : 30);
      List<String> EngSupports = new ArrayList<String>();
      for (User user : users) {
        EngSupports.add(user.getUserName());
      }
      return EngSupports;
    } catch (Throwable e) {
      LOG.error("Can't retrieve the list of support engineers " + e);
      return null;
    }
  }

  @Override
  public Log getLogger() {
    return LOG;
  }
}
