/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.support;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

public class SupportViewController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(SupportViewController.class);
    @Inject
    TicketService ticketService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<TicketDTO> getAllTickets() {
        try {
            User user = this.getCurrentUser();
            List tickets = this.ticketService.getEngSupportTickets(user);
            return tickets;
        }
        catch (Throwable e) {
            LOG.error((Object)("Exception when retrieving tickets" + e));
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    public Log getLogger() {
        return LOG;
    }
}

