/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketAdministration;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.entity.SpaceEntity;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class TicketAdministrationController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketAdministrationController.class);
    @Inject
    TicketService ticketService;
    @Inject
    OrganizationService organizationService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<TicketDTO> getAllTickets() {
        try {
            List tickets = this.ticketService.getTickets();
            return tickets;
        }
        catch (Throwable e) {
            LOG.error((Object)("Exception when retrieving tickets" + e));
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public TicketDTO saveTicket(@Jackson TicketDTO ticketDTO) throws Exception {
        try {
            String groupID = ticketDTO.getSpaceGroupId();
            SpaceEntity spaceEntity = this.ticketService.getSpaceByGroupId(groupID);
            return this.ticketService.UpdateTicketDTO(ticketDTO, spaceEntity);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating ticket", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<String> getEngSupportsUsernames(@Jackson TicketDTO ticketDTO) {
        try {
            String spaceGroupId = ticketDTO.getSpaceGroupId();
            String groupId = this.ticketService.getManagersGroupId(spaceGroupId);
            ListAccess EngSupportList = this.organizationService.getUserHandler().findUsersByGroupId(groupId);
            User[] users = (User[])EngSupportList.load(0, EngSupportList.getSize() < 30 ? EngSupportList.getSize() : 30);
            ArrayList<String> EngSupports = new ArrayList<String>();
            for (User user : users) {
                EngSupports.add(user.getUserName());
            }
            return EngSupports;
        }
        catch (Throwable e) {
            LOG.error((Object)("Can't retrieve the list of support engineers " + e));
            return null;
        }
    }

    public Log getLogger() {
        return LOG;
    }
}

