/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.cs.dto.BasicEntityDTO;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.exception.EntityAlreadyExistsException;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.util.SpacePageUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;

@SessionScoped
public class SpaceController
extends CSControllerBase {
    private static Log log = ExoLogger.getLogger(SpaceController.class);
    @Inject
    OrganizationService organizationService;
    @Inject
    CSSpaceService csSpaceService;
    @Inject
    TicketService ticketService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        try {
            return this.addSpaceURL(this.csSpaceService.getAllSpaces());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    private List<SpaceDTO> addSpaceURL(List<SpaceDTO> allSpaces) {
        ArrayList<SpaceDTO> spaces = new ArrayList<SpaceDTO>();
        for (SpaceDTO spaceDTO : allSpaces) {
            spaceDTO.setUrl(SpacePageUtils.getSpaceHomeURL((String)spaceDTO.getGroupId(), (String)spaceDTO.getName()));
            spaces.add(spaceDTO);
        }
        return spaces;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<TicketDTO> getTicketsOfSpace(@Jackson SpaceDTO spaceDTO) {
        if (spaceDTO == null) {
            throw new IllegalStateException("Wrong HTTP Request, spaceDTO is null");
        }
        return this.ticketService.getTicketsOfSpace(spaceDTO.getGroupId());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    public Response saveSpace(@Jackson SpaceDTO spaceDTO) {
        try {
            if (spaceDTO == null) {
                throw new IllegalStateException("Wrong HTTP Request, spaceDTO is null");
            }
            spaceDTO.setOwner(this.getCurrentUser().getUserName());
            spaceDTO = this.csSpaceService.saveSpace(spaceDTO);
            return Response.ok((CharSequence)spaceDTO.getUrl());
        }
        catch (EntityAlreadyExistsException e) {
            log.warn((Object)"Space already exists", (Throwable)e);
            return Response.status((int)500).content((CharSequence)"#cs.spaceAlreadyExists");
        }
        catch (Exception e) {
            log.error((Object)"Error when saving Space", (Throwable)e);
            return Response.status((int)500);
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    @Jackson
    public List<BasicEntityDTO> findGroups(String query) throws Exception {
        Query usersQuery = new Query();
        usersQuery.setFirstName("*" + query + "*");
        Collection list = this.organizationService.getGroupHandler().getAllGroups();
        ArrayList<BasicEntityDTO> groupDTOs = new ArrayList<BasicEntityDTO>();
        for (Group group : list) {
            if (!group.getLabel().toLowerCase().contains(query.toLowerCase())) continue;
            groupDTOs.add(new BasicEntityDTO("@" + group.getId(), group.getLabel(), null, null, null));
        }
        return groupDTOs;
    }

    @Resource
    @Ajax
    @MimeType.JSON
    @Jackson
    public List<BasicEntityDTO> findUsers(String query) throws Exception {
        Query usersQuery = new Query();
        usersQuery.setUserName("*" + query + "*");
        ListAccess list = this.organizationService.getUserHandler().findUsersByQuery(usersQuery, UserStatus.ENABLED);
        User[] users = (User[])list.load(0, list.getSize() < 10 ? list.getSize() : 10);
        ArrayList<BasicEntityDTO> userDTOs = new ArrayList<BasicEntityDTO>();
        for (User user : users) {
            userDTOs.add(new BasicEntityDTO("@" + user.getUserName(), user.getDisplayName(), null, "contact", user.getUserName()));
        }
        return userDTOs;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    public Log getLogger() {
        return log;
    }
}

