/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketAdministration;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

public class TicketAdministrationController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketAdministrationController.class);
    @Inject
    TicketService ticketService;
    @Inject
    TicketStatusFlowService ticketStatusFlowService;
    @Inject
    CSSpaceService spaceService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<TicketDTO> getAllTickets(String filter, String selectedSpace, String selectedStatus) {
        try {
            if (filter.equals("allmytickets")) {
                return this.ticketService.getAssignedTickets(this.getCurrentUser().getUserName(), selectedSpace, true, selectedStatus);
            }
            if (filter.equals("allopentickets")) {
                return this.ticketService.getTickets(selectedSpace, false, selectedStatus);
            }
            if (filter.equals("alltickets")) {
                return this.ticketService.getTickets(selectedSpace, true, selectedStatus);
            }
            return this.ticketService.getAssignedTickets(this.getCurrentUser().getUserName(), selectedSpace, false, selectedStatus);
        }
        catch (Throwable e) {
            LOG.error((Object)("Exception when retrieving tickets" + e));
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public TicketDTO saveTicket(@Jackson TicketDTO ticketDTO) throws Exception {
        try {
            return this.ticketService.updateTicket(ticketDTO, this.getCurrentUser());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating ticket", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<User> getSupportUsernames(@Jackson TicketDTO ticketDTO) {
        try {
            return CSUtils.getSupportMembers();
        }
        catch (Throwable e) {
            LOG.error((Object)("Can't retrieve the list of support engineers " + e));
            return null;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<String> getSeverities(@Jackson TicketDTO ticketDTO) {
        ArrayList<String> severities = new ArrayList<String>();
        if (ticketDTO.getType().equals((Object)IssueType.INCIDENT)) {
            severities.add(IssueSeverity.SEVERITY_1.name());
            severities.add(IssueSeverity.SEVERITY_2.name());
            severities.add(IssueSeverity.SEVERITY_3.name());
        } else if (ticketDTO.getType().equals((Object)IssueType.INFORMATION)) {
            severities.add(IssueSeverity.SEVERITY_4.name());
        }
        return severities;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<String> getTicketTypes() {
        ArrayList<String> ticketTypes = new ArrayList<String>();
        ticketTypes.add(IssueType.INCIDENT.name());
        ticketTypes.add(IssueType.INFORMATION.name());
        return ticketTypes;
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public Map<String, List<FlowState>> loadStatuses() {
        return this.ticketStatusFlowService.getAllStatuses();
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        return this.spaceService.getAllSpaces();
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public String deleteTicket(@Jackson TicketDTO ticket) {
        this.ticketService.deleteTicket(ticket);
        return "OK";
    }

    public Log getLogger() {
        return LOG;
    }
}

