/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.ticketMenu;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.tickets.FlowState;
import org.exoplatform.cs.service.tickets.TicketStatusFlowService;
import org.exoplatform.cs.service.util.CSUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class TicketMenuController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(TicketMenuController.class);
    private String bundleString;
    ResourceBundle bundle;
    private List<String> statusList = new ArrayList();
    @Inject
    TicketService ticketService;
    @Inject
    TicketStatusFlowService ticketStatusFlowService;
    @Inject
    CSSpaceService spaceService;
    @Inject
    ForumService forumService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<FlowState> getFlowStats(String name) {
        try {
            return this.ticketStatusFlowService.getFlowbyName(name).getStates();
        }
        catch (Exception e) {
            LOG.info((Object)"Flow  unfound");
            return new ArrayList<FlowState>();
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<String> getAllowedStates(String name) {
        try {
            String role = "customer";
            if (CSUtils.canManage().booleanValue()) {
                role = "support";
            }
            ArrayList<String> roles = new ArrayList<String>();
            for (FlowState state : this.ticketStatusFlowService.getFlowbyName(name).getStates()) {
                if (!state.getRole().equals("any") && !state.getRole().equals(role)) continue;
                roles.add(state.getState());
            }
            return roles;
        }
        catch (Exception e) {
            LOG.info((Object)"Flow  unfound");
            return new ArrayList<String>();
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public TicketDTO getTicket() {
        Identity assigneeId;
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        String uri = requestContext.getRequest().getRequestURI();
        if (!uri.contains("/forum/topic/")) {
            return null;
        }
        String topicId = uri.split("/forum/topic/")[1].split("/")[0];
        TicketDTO ticketDTO = this.ticketService.findById(topicId);
        if (ticketDTO.getAssignee() != null && (assigneeId = this.identityManager.getOrCreateIdentity("organization", ticketDTO.getAssignee(), false)) != null) {
            Profile profile = assigneeId.getProfile();
            ticketDTO.setAssignee(profile.getFullName());
        }
        return ticketDTO;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public TicketDTO saveTicket(@Jackson TicketDTO ticketDTO) throws Exception {
        try {
            return this.ticketService.updateTicket(ticketDTO, this.getCurrentUser());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating ticket", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.GET})
    @MimeType.JSON
    @Jackson
    public List<SpaceDTO> getSpaces() {
        return this.spaceService.getAllSpaces();
    }

    public Log getLogger() {
        return LOG;
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getJiraDetails(String id) {
        try {
            String result = this.getJSON("https://jira.exoplatform.org/rest/api/latest/issue/" + id);
            if (result == null) {
                return Response.status((int)401);
            }
            return Response.ok((CharSequence)result);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting jira", e);
            return Response.status((int)500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getJSON(String url) {
        HttpURLConnection c = null;
        try {
            URL u = new URL(url);
            c = (HttpURLConnection)u.openConnection();
            c.setRequestMethod("GET");
            c.setRequestProperty("Content-length", "0");
            c.setUseCaches(false);
            c.setAllowUserInteraction(false);
            c.connect();
            int status = c.getResponseCode();
            switch (status) {
                case 401: {
                    String string = null;
                    return string;
                }
                case 200: 
                case 201: {
                    BufferedReader br = new BufferedReader(new InputStreamReader(c.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while (true) {
                        String line;
                        if ((line = br.readLine()) == null) {
                            br.close();
                            String string = sb.toString();
                            return string;
                        }
                        sb.append(line + "\n");
                    }
                }
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)"error");
            return null;
        }
        finally {
            if (c != null) {
                try {
                    c.disconnect();
                }
                catch (Exception ex) {
                    LOG.error((Object)"error");
                }
            }
        }
    }
}

