define("ticketChartsControllers", ["SHARED/jquery", "SHARED/juzu-ajax"], function ($, jz) {
    var ticketChartsCtrl = function ($scope, $q, $timeout, $http, $filter) {
        var ticketChartsContainer = $('#ticketCharts');
        var deferred = $q.defer();
        $scope.selectedSpace = null;
        $scope.spaces=[];
        $scope.showGraphs = false;
        $scope.showSpaces = false;

        $scope.pieChartObject = {};
        $scope.pieChartObject.options = {
            backgroundColor: 'transparent',
            pieHole: 0.3,
        };
        $scope.pieChartObject.type = "PieChart";


        $scope.setResultMessage = function (text, type) {
            $scope.resultMessageClass = "alert-" + type;
            $scope.resultMessageClassExt = "uiIcon" + type.charAt(0).toUpperCase()+ type.slice(1);
            $scope.showAlert = true;
            $scope.resultMessage = text;
        }


        $scope.loadBundle = function () {
            $http({
                method: 'GET',
                url: ticketChartsContainer.jzURL('TicketChartsController.getBundle') + "&locale=" + eXo.env.portal.language
            }).then(function successCallback(data) {
                $scope.i18n = data.data;
                deferred.resolve(data);
                /*$scope.setResultMessage(data, "success");*/
                $scope.showAlert = false;
            }, function errorCallback(data) {
                $scope.setResultMessage($scope.i18n.defaultError, "error");
            });
        }



        $scope.getTicketsChartData = function (spaceId) {
            $http({
                method: 'GET',
                url: ticketChartsContainer.jzURL('TicketChartsController.getTicketsChartData')+ "&spaceId="+spaceId
            }).then(function successCallback(data) {
                $scope.ticketsNumberList = data.data;

                    $scope.showGraphs = true;

                      var ticketsArray = [];
                        for(var i = 0; i < $scope.ticketsNumberList.length; i++) {
                             var obj = $scope.ticketsNumberList[i];
                                      ticketsArray.push({ c: [{v: $scope.i18n[obj.status]}, {v: obj.ticketNumber}]});
                                 }
                    $scope.pieChartObject.data = {"cols": [
                        {id: "t", label: "Topping", type: "string"},
                        {id: "s", label: "Slices", type: "number"}
                    ], "rows":  ticketsArray
                    };

                $scope.showGraphs = true;
                deferred.resolve(data);
            }, function errorCallback(data) {
                $scope.setResultMessage($scope.i18n.defaultError, "error");
            });
        }


        $scope.loadData = function () {
            $http({
                method: 'GET',
                url: ticketChartsContainer.jzURL('TicketChartsController.getData')
            }).then(function successCallback(data) {
                d = data.data;
                if(d.currentSpace==null){
                $scope.loadSpaces();
                $scope.showSpaces = true;
                }else{
                $scope.getTicketsChartData(d.currentSpace);
                }
                deferred.resolve(data);
            }, function errorCallback(data) {
                $scope.setResultMessage($scope.i18n.defaultError, "error");
            });
        }

        $scope.loadSpaces = function () {
            $http({
                method: 'GET',
                url: ticketChartsContainer.jzURL('TicketChartsController.getSpaces')
            }).then(function successCallback(data) {
                $scope.spaces = data.data;

                $scope.showAlert = false;
            }, function errorCallback(data) {
                $scope.setResultMessage($scope.i18n.defaultError, "error");
            });

        };


        $scope.loadBundle();
        $scope.loadData();

        $('#ticketCharts').css('visibility', 'visible');
        $(".csLoadingBar").remove();

    };
        return ticketChartsCtrl;

});
