/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.quickticket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import juzu.Action;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.SessionScoped;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.request.Request;
import juzu.plugin.jackson.Jackson;
import juzu.request.RequestContext;
import juzu.template.Template;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.IssueSeverity;
import org.exoplatform.cs.dto.IssueType;
import org.exoplatform.cs.dto.SpaceDTO;
import org.exoplatform.cs.dto.TicketDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.portlet.quickticket.QuickTicketController_;
import org.exoplatform.cs.service.CSSpaceService;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.cs.service.TicketService;
import org.exoplatform.cs.service.util.SpacePageUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.json.JSONObject;

@SessionScoped
public class QuickTicketController
extends CSControllerBase {
    private static Log LOG = ExoLogger.getLogger(QuickTicketController.class);
    private static String SPACE_GROUP_ID = "exo.cs.addon.spaceGroupId";
    private static String SPACE_GROUP_ID_DEFAULT_VALUE = "/spaces/exo_employees";
    @Inject
    TicketService ticketService;
    @Inject
    CSSpaceService csSpaceService;
    @Inject
    EnvironmentService environmentService;
    @Inject
    ListenerService listenerService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTemplate;
    @Inject
    @Path(value="edit.gtmpl")
    Template editTemplate;
    List<FileItem> uploadedFile = new ArrayList();

    @View
    public Response.Content index(RequestContext requestContext) {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        PortletMode mode = (PortletMode)requestContext.getProperty(JuzuPortlet.PORTLET_MODE);
        String groupId = prefs.getValue(SPACE_GROUP_ID, SPACE_GROUP_ID_DEFAULT_VALUE);
        LOG.info("Group ID value is {}", new Object[]{groupId});
        if (PortletMode.EDIT.equals((Object)mode)) {
            List spaces = this.csSpaceService.getAllSpaces();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("selectedSpace", groupId);
            parameters.put("spaces", spaces);
            return this.editTemplate.with(parameters).ok();
        }
        ArrayList<String> errors = new ArrayList<String>();
        if (groupId != null) {
            try {
                SpaceDTO parameters = this.csSpaceService.getSpace(groupId);
            }
            catch (Exception e) {
                LOG.error("Error retrieving space from group ID {}", new Object[]{groupId, e});
                errors.add("Please select a target customer space in the preferences of the portlet");
            }
            try {
                EnvironmentDTO environment = this.environmentService.getSpaceDefaultEnvironment(groupId);
                if (environment == null) {
                    errors.add("Please create an environment for the selected space");
                }
            }
            catch (Exception e) {
                errors.add("Please create an environment for the selected space");
            }
        } else {
            errors.add("Please select a target customer space in the preferences of the portlet");
        }
        return this.indexTemplate.with().set("errors", errors).ok();
    }

    @View
    public Response.View edit() {
        return QuickTicketController_.edit();
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    public Response saveTicket(@Jackson TicketDTO ticketDTO) {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        ticketDTO.setEnvironmentId(Long.valueOf(0L));
        ticketDTO.setSeverity(IssueSeverity.SEVERITY_3);
        ticketDTO.setType(IssueType.INCIDENT);
        String groupId = prefs.getValue(SPACE_GROUP_ID, SPACE_GROUP_ID_DEFAULT_VALUE);
        try {
            SpaceDTO space = this.csSpaceService.getSpace(groupId);
            EnvironmentDTO environment = this.environmentService.getSpaceDefaultEnvironment(groupId);
            if (environment == null) {
                throw new Exception("No Environment is configured for this space, please create one");
            }
            ticketDTO.setEnvironmentId(environment.getId());
            ticketDTO.setEnvironmentName(environment.getName());
            ticketDTO.setSpaceGroupId(groupId);
            ticketDTO.setFiles(this.uploadedFile);
            User user = this.getCurrentUser();
            String spaceLink = SpacePageUtils.getSpaceHomeURL((String)groupId, (String)space.getName());
            this.ticketService.createTicket(ticketDTO, user, spaceLink);
            this.uploadedFile.clear();
            String ticketLink = spaceLink + "/forum/topic/" + ticketDTO.getId();
            ticketDTO.setLink(ticketLink);
            this.ticketService.updateTicketLink(ticketDTO, ticketLink);
            JSONObject ticketResponse = new JSONObject();
            ticketResponse.append("link", (Object)ticketDTO.getLink());
            ticketResponse.append("label", (Object)ticketDTO.getTitle());
            try {
                HashMap<String, String> gam = new HashMap<String, String>();
                gam.put("ruleTitle", "openNewTribeFeedback");
                gam.put("senderId", user.getUserName());
                gam.put("receiverId", user.getUserName());
                gam.put("object", ticketLink);
                this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)"");
                LOG.info((Object)"Tribe Feedback Gamification event broadcast ");
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot launch Tribe Feedback Gamification event" + e.getMessage()), (Throwable)e);
            }
            return Response.ok((CharSequence)ticketResponse.toString());
        }
        catch (Exception e) {
            LOG.error((Object)"Error when saving Task/Forum Topic", (Throwable)e);
            return Response.status((int)500);
        }
    }

    @Action
    @Route(value="updateSettings")
    public Response.View updateSettings(String spaceGroupId) throws Exception {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        prefs.setValue(SPACE_GROUP_ID, spaceGroupId);
        prefs.store();
        return QuickTicketController_.index();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    public Log getLogger() {
        return LOG;
    }
}

