/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.environment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.TypeDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@SessionScoped
public class EnvironmentController
extends CSControllerBase {
    private static Log log = ExoLogger.getLogger(EnvironmentController.class);
    @Inject
    EnvironmentService environmentService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<EnvironmentDTO> getEnvironments() {
        List<Object> environments = new ArrayList<EnvironmentDTO>();
        try {
            String spaceGroupId = this.getCurrentSpaceId();
            environments = this.environmentService.getSpaceEnvironments(spaceGroupId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return environments;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<EnvironmentDTO> saveEnvironment(@Jackson EnvironmentDTO envDTO) throws Exception {
        try {
            if (envDTO.getSpaceGroupId() == null) {
                envDTO.setSpaceGroupId(this.getCurrentSpaceId());
            }
            this.environmentService.saveEnvironment(envDTO);
            return this.getEnvironments();
        }
        catch (Exception e) {
            log.error((Object)("Error while saving environment: " + envDTO), (Throwable)e);
            throw e;
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    @Jackson
    public Map<String, List<TypeDTO>> getTypes() throws Exception {
        HashMap<String, List<TypeDTO>> types = new HashMap<String, List<TypeDTO>>();
        types.put("JVMType", this.environmentService.getTypeObjects("JVMType"));
        types.put("OSType", this.environmentService.getTypeObjects("OSType"));
        types.put("ASType", this.environmentService.getTypeObjects("ASType"));
        types.put("SSOType", this.environmentService.getTypeObjects("SSOType"));
        types.put("DBType", this.environmentService.getTypeObjects("DBType"));
        types.put("EnvType", this.environmentService.getTypeObjects("EnvType"));
        return types;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveType(@Jackson TypeDTO typeDTO) throws Exception {
        try {
            this.environmentService.saveType(typeDTO);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void deleteType(@Jackson TypeDTO typeDTO) throws Exception {
        try {
            this.environmentService.removeType(typeDTO);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<EnvironmentDTO> deleteEnvironment(@Jackson EnvironmentDTO envDTO) {
        try {
            this.environmentService.remove(envDTO);
            return this.getEnvironments();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    public Log getLogger() {
        return log;
    }
}

