/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.portlet.settings;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.cs.dto.EnvironmentDTO;
import org.exoplatform.cs.dto.TypeDTO;
import org.exoplatform.cs.portlet.common.CSControllerBase;
import org.exoplatform.cs.service.EnvironmentService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@SessionScoped
public class SettingsController
extends CSControllerBase {
    private static Log log = ExoLogger.getLogger(SettingsController.class);
    @Inject
    EnvironmentService environmentService;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Resource
    @Ajax
    @MimeType.JSON
    @Jackson
    public Map<String, List<TypeDTO>> getTypes() throws Exception {
        HashMap<String, List<TypeDTO>> types = new HashMap<String, List<TypeDTO>>();
        types.put("JVMType", this.environmentService.getTypeObjects("JVMType"));
        types.put("OSType", this.environmentService.getTypeObjects("OSType"));
        types.put("ASType", this.environmentService.getTypeObjects("ASType"));
        types.put("SSOType", this.environmentService.getTypeObjects("SSOType"));
        types.put("DBType", this.environmentService.getTypeObjects("DBType"));
        types.put("EnvType", this.environmentService.getTypeObjects("EnvType"));
        return types;
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public TypeDTO saveType(@Jackson TypeDTO typeDTO) throws Exception {
        try {
            return this.environmentService.saveType(typeDTO);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public List<EnvironmentDTO> loadAllEnvironments() throws Exception {
        try {
            SpaceService spaceService = (SpaceService)PortalContainer.getComponent(SpaceService.class);
            List environments = this.environmentService.getAllEnvironments();
            for (EnvironmentDTO env : environments) {
                Space space = spaceService.getSpaceByGroupId(env.getSpaceGroupId());
                if (space == null) continue;
                env.setSpaceGroupId(space.getDisplayName());
            }
            return environments;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void deleteType(@Jackson TypeDTO typeDTO) throws Exception {
        try {
            this.environmentService.removeType(typeDTO);
        }
        catch (Exception e) {
            log.error((Object)"An error occured while deleting TypeEntity", (Throwable)e);
            throw e;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle(String locale) {
        return super.getBundle(new Locale(locale));
    }

    public Log getLogger() {
        return log;
    }
}

