// Bootstrap manually the ng application, since :
// - it allows to correctly reinit the ng app after a (portal) page edition. Indeed, if we use the automatic init,
//   when the (portal) page is edited and then saved, the module are not registered again, so they are not executed
// - it is a good practice if we want to allow several ng app in the same html page (which could be the case with several portlets)
require( ["SHARED/jquery", "spaceControllers"], function ( $,  spaceControllers)
{
	$( document ).ready(function() {
	  var spaceAppRoot = $('#spaceAddon');
      var spaceApp = angular.module('spaceApp', []);
      spaceApp.directive('onlyDigits', function () {

                   return {
                       restrict: 'A',
                       require: '?ngModel',
                       link: function (scope, element, attrs, modelCtrl) {
                           modelCtrl.$parsers.push(function (inputValue) {
                               if (inputValue == undefined) return '';
                               var transformedInput = inputValue.replace(/[^0-9]/g, '');
                               if (transformedInput !== inputValue) {
                                   modelCtrl.$setViewValue(transformedInput);
                                   modelCtrl.$render();
                               }
                               return transformedInput;
                           });
                       }
                   };
               });
      try {
        spaceApp.controller('spaceCtrl', spaceControllers);
		  angular.bootstrap(spaceAppRoot, ['spaceApp']);
      } catch(e) {
    	  console.log(e);
      }
	});
});