require(["SHARED/jquery", "ticketMenuControllers"], function ($, ticketMenuControllers) {
    function initializeCustomerRateListener() {
        var rateIndicator = document.getElementsByClassName("rateIndic");
        var switchdiv = document.getElementsByClassName('switch')[0];
        if (rateIndicator != null) {
            for (var i = 0; i < rateIndicator.length; i++) {
                rateIndicator[i].addEventListener("click", function () {
                    if (switchdiv != null) {
                        document.getElementById('ticketMenu').scrollIntoView();
                        switchdiv.style.animation = 'pulse 1s infinite';
                        setTimeout(function () { switchdiv.style.animation = null; }, 5000);
                    }
                });
            }
        }

        if (window.location.href.includes("#csrate")) {
            if (switchdiv != null) {
                document.getElementById('ticketMenu').scrollIntoView();
                switchdiv.style.animation = 'pulse 1s infinite';
                setTimeout(function () { switchdiv.style.animation = null; }, 5000);
            }
            history.pushState({}, null, window.location.href.replace(/#csrate$/, ""));
        }
    }

    $(document).ready(function () {
        var ticketMenuAppRoot = $('#ticketMenu');
        var ticketMenuApp = angular.module('ticketsChartsApp', ['ngSanitize']);
        ticketMenuApp.filter('decodeStr', function ($sce) {
            return function (str) {
                if (str == null) {
                    return $sce.trustAsHtml("");
                }
                var textArea = document.createElement('textarea');
                textArea.innerHTML = str;
                return $sce.trustAsHtml(textArea.innerText);
            }
        });
        ticketMenuApp.filter('parseJiraUrl', function ($sce) {
            return function (jiratickets) {
                if (jiratickets == null) {
                    return $sce.trustAsHtml("");
                }
                const JIRA_PATTERN = /[A-Z]+-[0-9]+/g;
                const TASK_PATTERN = /[0-9]+/g;
                const JIRASERVERURL = "https://jira.exoplatform.org";
                jiratickets = jiratickets.replace(/[|&;$%@"<>()+,]/g, " ").replace(/\s+/, " ").trim();
                var jiralinks = "";
                jiratickets.split(" ").forEach(elt => {
                    if (elt.match(JIRA_PATTERN)) {
                        jiralinks += '<a target=\"_blank\" href=\"' + JIRASERVERURL + '/browse/' + elt + '\" >' + elt + '</a> ';
                    } else if (elt.match(TASK_PATTERN)) {
                        jiralinks += '<a target="_blank" href="/portal/dw/tasks/taskDetail/' + elt + '" >' + elt + '</a> ';
                        getStatusColor(elt, '/portal/dw/tasks/taskDetail/' + elt)
                    } else {
                        jiralinks += elt + ' ';
                    }
                });
                return $sce.trustAsHtml(jiralinks.trim());
            }
        });
        try {
            ticketMenuApp.controller('ticketMenuCtrl', ticketMenuControllers);
            angular.bootstrap(ticketMenuAppRoot, ['ticketsChartsApp']);
        } catch (e) {
            console.log(e);
        }
        initializeCustomerRateListener();
    });

    function getStatusColor(item, url) {
        $.ajax({
            url: '/portal/rest/tasks/logs/' + item,
            type: "GET",
            dataType: 'json',
            async: true,
            success: function (data) {
                if (!data || data.length == 0 || !data[data.length - 1].task.status) {
                    return 0;
                }
                var status = data[data.length - 1].task.status.name;
                var affectedColor = "#"+stringToRGB(status);   
                $("a[href$='" + url + "']").css('color', affectedColor);
                $("a[href$='" + url + "']").attr('title', status.match(/[A-Z][a-z]+/g) ? status.match(/[A-Z][a-z]+/g).join(" ") : status);
            }
        });
    }
    function stringToRGB(str) {
        var hash = 0;
        for (var i = 0; i < str.length; i++) {
            hash = str.charCodeAt(i) + ((hash << 5) - hash);
        }
        var c = (hash & 0x00FFFFFF)
                .toString(16)
                .toUpperCase();
        return "00000".substring(0, 6 - c.length) + c;
    }
});
