/*
 * Decompiled with CFR 0.152.
 */
package org.services.notification.cms.templates.provider;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PostUpdateStatePlugin", template="war:/notification/templates/mail/postUpdateStatePlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"PostUpdateStatePlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            log.info((Object)("Prepare Mail notif for " + notification.getKey().getId()));
            String contentUpdater = notification.getValueOwnerParameter("CONTENT_UPDATER");
            String contentTitle = notification.getValueOwnerParameter("CONTENT_TITLE");
            String contentStatus = notification.getValueOwnerParameter("CONTENT_STATUS");
            String contentUrl = notification.getValueOwnerParameter("CONTENT_URL");
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            if (contentUpdater == null || IdentityConstants.SYSTEM.equals(contentUpdater)) {
                templateContext.put((Object)"USER", (Object)"SYSTEM");
                templateContext.put((Object)"AVATAR", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                templateContext.put((Object)"PROFILE_URL", (Object)"#");
            } else {
                Identity author = identityManager.getOrCreateIdentity("organization", contentUpdater, true);
                Profile profile = author.getProfile();
                templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName()));
                templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)author.getRemoteId()));
            }
            Identity receiver = identityManager.getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"LAST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("lastName").toString()));
            templateContext.put((Object)"CONTENT_TITLE", (Object)encoder.encode(contentTitle));
            templateContext.put((Object)"CONTENT_STATUS", (Object)encoder.encode(contentStatus));
            templateContext.put((Object)"CONTENT_UPDATER", (Object)encoder.encode(contentUpdater));
            templateContext.put((Object)"CONTENT_URL", (Object)encoder.encode(contentUrl));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity receiver = identityManager.getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap map = new HashMap();
            StringBuilder sb = new StringBuilder();
            return sb.toString();
        }
    }
}

