/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.uiexplorer.extention.webui.component;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanEnableVersionFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotFolderFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotIgnoreVersionNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotRootNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.pdfviewer.PDFViewerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

@ComponentConfig(events={@EventConfig(listeners={PrintDocumentActionListener.class})})
public class PrintDocumentActionComponent
extends UIComponent {
    private static final Log LOG = ExoLogger.getLogger((String)PrintDocumentActionComponent.class.getName());
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new IsNotRootNodeFilter("UIActionBar.msg.cannot-enable-version-rootnode"), new CanSetPropertyFilter(), new IsNotLockedFilter(), new CanEnableVersionFilter(), new IsNotEditingDocumentFilter(), new IsNotFolderFilter(), new IsNotIgnoreVersionNodeFilter());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void printJCRDocument(Node theNode) throws Exception {
        PDFViewerService pdfViewerService = (PDFViewerService)WCMCoreUtils.getService(PDFViewerService.class);
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        String repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
        File file = pdfViewerService.getPDFDocumentFile(theNode, repoName);
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        FileInputStream in = new FileInputStream(file);
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        pras.add(new Copies(1));
        DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(in, flavor, null);
        DocPrintJob job = service.createPrintJob();
        job.print(doc, pras);
        in.close();
        ByteArrayInputStream ff = new ByteArrayInputStream("\f".getBytes());
        SimpleDoc docff = new SimpleDoc(ff, flavor, null);
        DocPrintJob jobff = service.createPrintJob();
        jobff.print(docff, null);
    }

    public static class PrintDocumentActionListener
    extends UIActionBarActionListener<PrintDocumentActionComponent> {
        protected void processEvent(Event<PrintDocumentActionComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((PrintDocumentActionComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            uiExplorer.setIsHidePopup(false);
            try {
                PrintDocumentActionComponent.printJCRDocument(currentNode);
                LOG.info((Object)("## The Document [" + currentNode.getName() + "] has been successfully printed "));
            }
            catch (Exception E) {
                LOG.error((Object)("## Error during sending the document [" + currentNode.getName() + "] to the printer"));
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }
}

