/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.uiexplorer.extention.webui.form;

import java.util.Arrays;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/addons/explorer/extension/webui/popup/UISpaceListForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UISpaceListForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UISpaceListForm.class.getName());
    private SpaceService spaceService = null;
    private ListAccess<Space> spaceListAccess;
    private LinkedList<Space> spaceList = new LinkedList();
    private String remoteUser = null;

    public void activate() {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.remoteUser = requestContext.getRemoteUser();
        try {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            if (this.spaceService != null) {
                this.spaceListAccess = this.spaceService.getLastAccessedSpace(this.remoteUser, null);
            }
            if (this.spaceListAccess != null) {
                this.spaceList.addAll(Arrays.asList(this.spaceListAccess.load(0, 5)));
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"SpaceService could be 'null' when the Social profile isn't activated ", (Throwable)exception);
        }
        for (Space space : this.spaceList) {
            String spaceURL = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
            if (spaceURL == null || spaceURL.contains(space.getPrettyName())) continue;
            this.addUIFormInput((UIFormInput)new UICheckBoxInput(space.getDisplayName(), space.getShortName(), null));
        }
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UISpaceListForm> {
        public void execute(Event<UISpaceListForm> event) throws Exception {
            ((UIPopupContainer)((UISpaceListForm)((Object)event.getSource())).getAncestorOfType(UIPopupContainer.class)).cancelPopupAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UISpaceListForm> {
        public void execute(Event<UISpaceListForm> event) throws Exception {
            UISpaceListForm uiForm = (UISpaceListForm)((Object)event.getSource());
            RepositoryService repositoryService = (RepositoryService)uiForm.getApplicationComponent(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            Session targetSession = WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", manageableRepository);
            Node currentNode = null;
            UIJCRExplorerPortlet uiExplorerPorltet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiExplorerPorltet.findFirstComponentOfType(UIJCRExplorer.class);
            LinkedList<String> selectedSpace = new LinkedList<String>();
            for (UIComponent checkBox : uiForm.getChildren()) {
                if (!(checkBox instanceof UIFormInputBase) || !((Boolean)((UIFormInputBase)checkBox).getValue()).booleanValue()) continue;
                selectedSpace.add(((UIFormInputBase)checkBox).getBindingField());
            }
            currentNode = uiExplorer.getCurrentNode();
            for (String spacePrettyName : selectedSpace) {
                if (targetSession.getWorkspace().getName().equals(currentNode.getSession().getWorkspace().getName())) {
                    targetSession.getWorkspace().copy(currentNode.getPath(), String.format("/Groups/spaces/%s/Documents/%s", spacePrettyName, currentNode.getName()));
                    targetSession.save();
                    continue;
                }
                try {
                    targetSession.getWorkspace().copy("collaboration", currentNode.getPath(), String.format("/Groups/spaces/%s/Documents/%s", spacePrettyName, currentNode.getName()));
                }
                catch (Exception e) {
                    try {
                        targetSession.getWorkspace().clone("collaboration", currentNode.getPath(), String.format("/Groups/spaces/%s/Documents/%s", spacePrettyName, currentNode.getName()), false);
                    }
                    catch (Exception f) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)f);
                    }
                }
            }
            uiExplorer.refreshExplorer();
            uiExplorerPorltet.setRenderedChild(UIJCRExplorer.class);
        }
    }
}

