/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.web.filter;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.filter.Filter;

public class PublicLinkFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String[] params = httpRequest.getRequestURI().split("/");
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            if (params.length == 7) {
                String uuid = params[5];
                Session session = sessionProvider.getSession("collaboration", repositoryService.getCurrentRepository());
                Node node = session.getNodeByUUID(uuid);
                httpResponse.setContentType(this.getMimeType(node));
                httpResponse.setCharacterEncoding("UTF-8");
                httpResponse.setStatus(200);
                InputStream in = this.getStream(node);
                ServletOutputStream out = response.getOutputStream();
                byte[] buffer = new byte[1024];
                int len = in.read(buffer);
                while (len != -1) {
                    out.write(buffer, 0, len);
                    len = in.read(buffer);
                }
            }
        }
        catch (Exception e) {
            httpResponse.setStatus(404);
        }
        finally {
            sessionProvider.close();
        }
    }

    private InputStream getStream(Node node) throws Exception {
        Node contentNode;
        if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) {
            InputStream inputStream = contentNode.getProperty("jcr:data").getStream();
            return inputStream;
        }
        return null;
    }

    private String getMimeType(Node node) throws Exception {
        if (node.hasNode("jcr:content")) {
            Node jcrContent = node.getNode("jcr:content");
            return jcrContent.getProperty("jcr:mimeType").getString();
        }
        return null;
    }
}

