/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.spaces.services.customization;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceCustomizationService {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceCustomizationService.class);
    private static final String GROUPS_PATH = "groupsPath";
    private static final String SPACE_GROUP_ID_PREFERENCE = "{spaceGroupId}";
    private static final String SPACE_NEW_HOME_PAGE_TEMPLATE = "demo space";
    private static final String SCV_PORTLEt_NAME = "SingleContentViewer";
    private NodeHierarchyCreator nodeHierarchyCreator = null;
    private DMSConfiguration dmsConfiguration = null;
    private RepositoryService repositoryService = null;
    private ConfigurationManager configurationManager = null;
    private DataStorage dataStorageService = null;
    private UserPortalConfigService userPortalConfigService = null;
    private SpaceService spaceService = null;
    private UserACL userACL = null;
    private String groupsPath;

    public SpaceCustomizationService(DataStorage dataStorageService_, UserPortalConfigService userPortalConfigService_, NodeHierarchyCreator nodeHierarchyCreator_, DMSConfiguration dmsConfiguration_, RepositoryService repositoryService_, ConfigurationManager configurationManager_, UserACL userACL_) {
        this.nodeHierarchyCreator = nodeHierarchyCreator_;
        this.dmsConfiguration = dmsConfiguration_;
        this.repositoryService = repositoryService_;
        this.userACL = userACL_;
        this.configurationManager = configurationManager_;
        this.dataStorageService = dataStorageService_;
        this.userPortalConfigService = userPortalConfigService_;
        this.groupsPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_PATH);
        if (this.groupsPath.lastIndexOf("/") == this.groupsPath.length() - 1) {
            this.groupsPath = this.groupsPath.substring(0, this.groupsPath.lastIndexOf("/"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSpaceHomePage(String spacePrettyName, String spaceGroupId) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            LOG.info((Object)("Updating '" + spaceGroupId + "' Space Home Page"));
            Page oldSpaceHomePage = this.dataStorageService.getPage(PortalConfig.GROUP_TYPE + "::" + spaceGroupId + "::" + this.getSpaceService().getSpaceApplicationConfigPlugin().getHomeApplication().getPortletName());
            Page customSpaceHomePage = this.userPortalConfigService.createPageTemplate(SPACE_NEW_HOME_PAGE_TEMPLATE, PortalConfig.GROUP_TYPE, spaceGroupId);
            customSpaceHomePage.setTitle(oldSpaceHomePage.getTitle());
            customSpaceHomePage.setName(oldSpaceHomePage.getName());
            customSpaceHomePage.setAccessPermissions(new String[]{"*:" + spaceGroupId});
            customSpaceHomePage.setEditPermission("manager:" + spaceGroupId);
            customSpaceHomePage.setOwnerType(PortalConfig.GROUP_TYPE);
            customSpaceHomePage.setOwnerId(spaceGroupId);
            this.editChildrenAccesPermisions(customSpaceHomePage.getChildren(), new String[]{"*:" + spaceGroupId});
            this.editSpaceURLPreference(customSpaceHomePage.getChildren(), spacePrettyName);
            this.dataStorageService.save(customSpaceHomePage);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while customizing the Space home page for space: " + spaceGroupId), (Throwable)e);
        }
        finally {
            try {
                RequestLifeCycle.end();
            }
            catch (Exception e) {
                LOG.warn((Object)("An exception has occurred while proceed RequestLifeCycle.end() : " + e.getMessage()));
            }
        }
    }

    public void createSpaceApplication(Space targetSpace, String targetSpaceName, String targetAppName) {
        if (targetSpaceName.equalsIgnoreCase(targetSpace.getPrettyName()) && !SpaceUtils.isInstalledApp((Space)targetSpace, (String)targetAppName)) {
            try {
                this.spaceService.installApplication(targetSpace.getId(), targetAppName);
                this.spaceService.activateApplication(targetSpace.getId(), targetAppName);
            }
            catch (SpaceException E) {
                LOG.error((Object)"####### Error to install My CRM Application", (Throwable)E);
            }
        }
    }

    private void editSpaceURLPreference(List<ModelObject> children, String prefValue) throws Exception {
        if ((children == null || children.size() == 0) && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Can not get a portlet application from children.\nChildren == null or have no items");
        }
        for (ModelObject modelObject : children) {
            if (modelObject instanceof Container) {
                this.editSpaceURLPreference(((Container)modelObject).getChildren(), prefValue);
                continue;
            }
            if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
            Application application = (Application)modelObject;
            Portlet portletPreference = (Portlet)this.dataStorageService.load(application.getState(), ApplicationType.PORTLET);
            if (portletPreference == null) {
                portletPreference = new Portlet();
            }
            portletPreference.putPreference(new Preference("SPACE_URL", prefValue, false));
        }
    }

    private void editChildrenAccesPermisions(List<ModelObject> children, String[] accessPermissions) {
        if (children != null && children.size() > 0) {
            for (ModelObject modelObject : children) {
                if (modelObject instanceof Container) {
                    ((Container)modelObject).setAccessPermissions(accessPermissions);
                    this.editChildrenAccesPermisions(((Container)modelObject).getChildren(), accessPermissions);
                    continue;
                }
                if (!(modelObject instanceof Application) || !((Application)modelObject).getType().equals(ApplicationType.PORTLET)) continue;
                Application application = (Application)modelObject;
                application.setAccessPermissions(accessPermissions);
            }
        }
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }
}

