/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.exoplatform.addons.populator.bean.CalendarBean;
import org.exoplatform.addons.populator.bean.EventBean;
import org.exoplatform.addons.populator.bean.InternalCalendarBean;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;

@Named(value="calendarService")
@ApplicationScoped
public class CalendarService {
    org.exoplatform.calendar.service.CalendarService calendarService_;
    OrganizationService organizationService_;
    Logger log = Logger.getLogger("CalendarService");

    @Inject
    public CalendarService(org.exoplatform.calendar.service.CalendarService calendarService, OrganizationService organizationService) {
        this.calendarService_ = calendarService;
        this.organizationService_ = organizationService;
    }

    public void setCalendarColors(List<CalendarBean> calendarBeans) {
        for (CalendarBean calendarBean : calendarBeans) {
            String username = calendarBean.getUser();
            List calendars = calendarBean.getCalendars();
            HashMap<String, InternalCalendarBean> map = new HashMap<String, InternalCalendarBean>();
            for (InternalCalendarBean calendar : calendars) {
                map.put(calendar.getName(), calendar);
            }
            String filtered = null;
            try {
                String[] calendarIdList;
                for (String calId : calendarIdList = this.getCalendarsIdList(username)) {
                    Calendar calendar = this.calendarService_.getCalendarById(calId);
                    String calName = calendar.getName();
                    if (map.containsKey(calName)) {
                        InternalCalendarBean calTemp = (InternalCalendarBean)map.get(calName);
                        calendar.setCalendarColor(calTemp.getColor());
                        if (calTemp.isUserCalendar()) {
                            this.calendarService_.saveUserCalendar(username, calendar, true);
                            continue;
                        }
                        this.calendarService_.savePublicCalendar(calendar, false);
                        continue;
                    }
                    filtered = calendar.getId();
                }
                if (filtered == null) continue;
                CalendarSetting setting = this.calendarService_.getCalendarSetting(username);
                setting.setFilterPublicCalendars(new String[]{filtered});
                this.calendarService_.saveCalendarSetting(username, setting);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createEvents(List<CalendarBean> calendarBeans) {
        try {
            for (CalendarBean calendarBean : calendarBeans) {
                String username = calendarBean.getUser();
                Map map = this.getCalendarsMap(username);
                if (calendarBean.getClearAll().booleanValue()) {
                    this.removeAllEvents(username);
                }
                List calendars = calendarBean.getCalendars();
                for (InternalCalendarBean calendar : calendars) {
                    for (EventBean event : calendar.getEvents()) {
                        this.saveEvent(username, calendar.isUserCalendar(), (String)map.get(calendar.getName()), event.getTitle(), event.getDayAsInt(), event.getStartHour(), event.getStartMinute(), event.getEndHour(), event.getEndMinute());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveEvent(String username, boolean isUserEvent, String calId, String summary, int day, int fromHour, int fromMin, int toHour, int toMin) throws Exception {
        CalendarEvent event = new CalendarEvent();
        event.setCalendarId(calId);
        event.setSummary(summary);
        event.setEventType(CalendarEvent.TYPE_EVENT);
        event.setRepeatType(CalendarEvent.RP_NOREPEAT);
        event.setPrivate(isUserEvent);
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTime().getTime());
        calendar.set(7, day);
        calendar.set(11, fromHour);
        calendar.set(12, fromMin);
        event.setFromDateTime(calendar.getTime());
        calendar.set(11, toHour);
        calendar.set(12, toMin);
        event.setToDateTime(calendar.getTime());
        if (isUserEvent) {
            this.calendarService_.saveUserEvent(username, calId, event, true);
        } else {
            this.calendarService_.savePublicEvent(calId, event, true);
        }
    }

    private void removeAllEvents(String username) throws Exception {
        List events = this.getEvents(username);
        for (CalendarEvent event : events) {
            if (event.isPrivate()) {
                this.calendarService_.removeUserEvent(username, event.getCalendarId(), event.getId());
                continue;
            }
            this.calendarService_.removePublicEvent(event.getCalendarId(), event.getId());
        }
    }

    private Map<String, String> getCalendarsMap(String username) {
        String[] calendarIdList;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String calId : calendarIdList = this.getCalendarsIdList(username)) {
            Calendar calendar = null;
            try {
                calendar = this.calendarService_.getCalendarById(calId);
                String calName = calendar.getName();
                map.put(calName, calId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return map;
    }

    private String[] getCalendarsIdList(String username) {
        StringBuilder sb = new StringBuilder();
        List listgroupCalendar = null;
        List listUserCalendar = null;
        try {
            listgroupCalendar = this.calendarService_.getGroupCalendars(this.getUserGroups(username), true, username);
            listUserCalendar = this.calendarService_.getUserCalendars(username, true);
        }
        catch (Exception e) {
            this.log.info("Error while checking User Calendar :" + e.getMessage());
        }
        for (GroupCalendarData g : listgroupCalendar) {
            for (Calendar c : g.getCalendars()) {
                sb.append(c.getId()).append(",");
            }
        }
        for (Calendar c : listUserCalendar) {
            sb.append(c.getId()).append(",");
        }
        String[] list = sb.toString().split(",");
        return list;
    }

    private List<CalendarEvent> getEvents(String username) {
        String[] calList = this.getCalendarsIdList(username);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
        eventQuery.setCalendarId(calList);
        List userEvents = null;
        try {
            userEvents = this.calendarService_.getEvents(username, eventQuery, calList);
        }
        catch (Exception e) {
            this.log.info("Error while checking User Events:" + e.getMessage());
        }
        return userEvents;
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.organizationService_.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }
}

