/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import juzu.SessionScoped;
import org.exoplatform.addons.populator.bean.WikiBean;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.xwiki.rendering.syntax.Syntax;

@Named(value="wikiService")
@SessionScoped
public class WikiService {
    org.exoplatform.wiki.service.WikiService wikiService_;
    Logger log = Logger.getLogger("WikiService");

    @Inject
    public WikiService(org.exoplatform.wiki.service.WikiService wikiService) {
        this.wikiService_ = wikiService;
    }

    public void createUserWiki(List<WikiBean> wikis) {
        for (WikiBean wiki : wikis) {
            this.createOrEditPage(wiki, wiki.getParent());
        }
    }

    private void createOrEditPage(WikiBean wikiBean, String parentTitle) {
        boolean forceNew = wikiBean.getNew();
        String title = wikiBean.getTitle();
        String filename = wikiBean.getFilename();
        String parent = parentTitle;
        String type = wikiBean.getType();
        type = "group".equals(type) ? PortalConfig.GROUP_TYPE : ("portal".equals(type) ? PortalConfig.PORTAL_TYPE : PortalConfig.USER_TYPE);
        String owner = wikiBean.getOwner();
        try {
            if (forceNew && !title.equals("Wiki Home") && this.wikiService_.isExisting(type, owner, TitleResolver.getId((String)title, (boolean)false))) {
                this.wikiService_.deletePage(type, owner, TitleResolver.getId((String)title, (boolean)false));
            }
            PageImpl page = this.wikiService_.isExisting(type, owner, TitleResolver.getId((String)title, (boolean)false)) ? (PageImpl)this.wikiService_.getPageById(type, owner, TitleResolver.getId((String)title, (boolean)false)) : (PageImpl)this.wikiService_.createPage(type, owner, title, TitleResolver.getId((String)parent, (boolean)false));
            String content = "= " + title + " =";
            if (filename != null) {
                content = Utils.getWikiPage((String)filename);
            }
            page.getContent().setText(content);
            page.setSyntax(Syntax.XWIKI_2_0.toIdString());
            page.checkin();
            page.checkout();
            if (wikiBean.getWikis() != null && wikiBean.getWikis().size() > 0) {
                for (WikiBean wiki : wikiBean.getWikis()) {
                    this.createOrEditPage(wiki, wikiBean.getTitle());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

