/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.portlet.populator;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.plugin.ajax.Ajax;
import juzu.template.Template;
import org.exoplatform.addons.populator.services.PopulatorService;

@SessionScoped
public class PopulatorApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template indexTemplate;
    @Inject
    @Path(value="custom.gtmpl")
    Template customTemplate;
    @Inject
    PopulatorService populatorService_;
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @View
    public Response.Content index(String category) {
        PortletPreferences portletPreferences = (PortletPreferences)this.providerPreferences.get();
        if ("".equals(this.populatorService_.getUsername())) {
            this.populatorService_.setUsername(portletPreferences.getValue("username", "benjamin"));
            this.populatorService_.setFullname(portletPreferences.getValue("fullname", "Benjamin Paillereau"));
            this.populatorService_.setLanguage(portletPreferences.getValue("language", "default"));
        }
        this.populatorService_.init();
        String data = this.populatorService_.getDataAsString();
        if (category == null) {
            category = "Summary";
        }
        String[] categories = new String[]{"Summary", "Custom"};
        Template target = this.indexTemplate;
        if ("Custom".equals(category)) {
            target = this.customTemplate;
        }
        return target.with().set("category", (Object)category).set("categories", (Object)categories).set("username", (Object)this.populatorService_.getUsername()).set("fullname", (Object)this.populatorService_.getFullname()).set("data", (Object)data).ok();
    }

    @Ajax
    @Resource
    public Response.Content start(String filter) {
        if ("1".equals(filter)) {
            this.populatorService_.init();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\"status\": \"OK\"}");
        this.populatorService_.start(Integer.parseInt(filter));
        return Response.ok((CharSequence)sb.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content save(String username, String fullname, String language) {
        this.populatorService_.setUsername(username);
        this.populatorService_.setFullname(fullname);
        this.populatorService_.setLanguage(language);
        StringBuilder sb = new StringBuilder();
        sb.append("{\"status\": \"OK\"}");
        return Response.ok((CharSequence)sb.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content elements() {
        return Response.ok((CharSequence)this.populatorService_.getCompletionAsJson()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }
}

