/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.populator.services;

import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import juzu.SessionScoped;
import org.exoplatform.addons.populator.services.Utils;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;

@Named(value="forumService")
@SessionScoped
public class ForumService {
    Logger log = Logger.getLogger("ForumService");
    org.exoplatform.forum.service.ForumService forumService_;
    PollService pollService_;
    KSDataLocation locator_;

    @Inject
    public ForumService(org.exoplatform.forum.service.ForumService forumService, PollService pollService, KSDataLocation locator) {
        this.forumService_ = forumService;
        this.pollService_ = pollService;
        this.locator_ = locator;
    }

    public void createCategoriesAndForum() {
        List categories = this.forumService_.getCategories();
        for (Category category : categories) {
            try {
                List forums = this.forumService_.getForums(category.getId(), "");
                for (Forum forum : forums) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createPosts(String username) {
        String forumName = "Public Discussions";
        try {
            Forum forum = this.getForumByName(forumName);
            Category cat = this.getCategoryByForumName(forumName);
            List topics = this.forumService_.getTopics(cat.getId(), forum.getId());
            if (topics.size() > 0) {
                return;
            }
            Topic topicNew = new Topic();
            topicNew.setOwner(username);
            topicNew.setTopicName("General");
            topicNew.setCreatedDate(new Date());
            topicNew.setModifiedBy(username);
            topicNew.setModifiedDate(new Date());
            topicNew.setLastPostBy(username);
            topicNew.setLastPostDate(new Date());
            topicNew.setDescription("General Topic");
            topicNew.setPostCount(0L);
            topicNew.setViewCount(0L);
            topicNew.setIsNotifyWhenAddPost("");
            topicNew.setIsModeratePost(false);
            topicNew.setIsClosed(false);
            topicNew.setIsLock(false);
            topicNew.setIsWaiting(false);
            topicNew.setIsActive(true);
            topicNew.setIcon("classNameIcon");
            topicNew.setIsApproved(true);
            topicNew.setCanView(new String[0]);
            topicNew.setCanPost(new String[0]);
            this.forumService_.saveTopic(cat.getId(), forum.getId(), topicNew, true, false, new MessageBuilder());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createPollAndVote() {
        String forumName = "Public Discussions";
        try {
            List polls = this.pollService_.getPagePoll();
            for (Poll poll : polls) {
                this.pollService_.removePoll(poll.getId());
            }
            Forum forum = this.getForumByName(forumName);
            Category cat = this.getCategoryByForumName(forumName);
            List topics = this.forumService_.getTopics(cat.getId(), forum.getId());
            if (topics.size() > 0) {
                Topic topic = (Topic)topics.get(0);
                String[] options = new String[]{"It's amazing", "I love it", "I like it", "No opinion"};
                String[] votes = new String[]{"50.0", "33.333336", "16.666668", "0.0"};
                String[] userVotes = new String[]{Utils.JAMES + ":2:0", Utils.JOHN + ":1:0", Utils.MARY + ":1:0"};
                Poll poll = new Poll();
                String pollPath = forum.getPath() + "/" + topic.getId();
                String pollId = topic.getId().replace(org.exoplatform.forum.service.Utils.TOPIC, org.exoplatform.forum.service.Utils.POLL);
                poll.setId(pollId);
                poll.setParentPath(pollPath);
                poll.setInTopic(true);
                poll.setQuestion("Do you like our new Intranet?");
                poll.setOption(options);
                poll.setOwner(Utils.MARY);
                poll.setIsMultiCheck(true);
                poll.setShowVote(true);
                poll.setIsAgainVote(true);
                poll.setIsClosed(false);
                poll.setTimeOut(0L);
                this.pollService_.savePoll(poll, true, false);
                poll.setVote(votes);
                poll.setUserVote(userVotes);
                poll.setModifiedBy(Utils.MARY);
                this.pollService_.savePoll(poll, true, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Forum getForumByName(String forumName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator_.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(forumName).append("%')]");
        NodeIterator iter = this.forumService_.search(sb.toString());
        if (iter.hasNext()) {
            Node forumNode = (Node)iter.next();
            Forum forum = new Forum();
            PropertyReader reader = new PropertyReader(forumNode);
            forum.setId(forumNode.getName());
            forum.setPath(forumNode.getPath());
            forum.setOwner(reader.string("exo:owner"));
            forum.setForumName(reader.string("exo:name"));
            forum.setViewer(reader.strings("exo:viewer"));
            return forum;
        }
        return null;
    }

    private Category getCategoryByForumName(String forumName) throws Exception {
        Node forumNode;
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator_.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(forumName).append("%')]");
        NodeIterator iter = this.forumService_.search(sb.toString());
        if (iter.hasNext() && (forumNode = (Node)iter.next()).getParent() != null) {
            Node cateNode = forumNode.getParent();
            Category cat = new Category(cateNode.getName());
            cat.setPath(cateNode.getPath());
            PropertyReader reader = new PropertyReader(cateNode);
            cat.setOwner(reader.string("exo:owner"));
            cat.setCategoryName(reader.string("exo:name"));
            return cat;
        }
        return null;
    }
}

