/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.injection.core.module;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.injection.helper.InjectorUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarModule {
    private final Log LOG = ExoLogger.getLogger(CalendarModule.class);
    protected CalendarService calendarService;
    protected ExtendedCalendarService extendedCalendarService;
    protected OrganizationService organizationService;

    public CalendarModule(CalendarService calendarService, ExtendedCalendarService extendedCalendarService, OrganizationService organizationService) {
        this.calendarService = calendarService;
        this.extendedCalendarService = extendedCalendarService;
        this.organizationService = organizationService;
    }

    public void setCalendarColors(JSONArray calendars) {
        for (int i = 0; i < calendars.length(); ++i) {
            try {
                JSONObject calendarObject = calendars.getJSONObject(i);
                String username = calendarObject.getString("user");
                JSONArray userCalendars = calendarObject.getJSONArray("calendars");
                HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
                for (int j = 0; j < userCalendars.length(); ++j) {
                    JSONObject userCalendar = userCalendars.getJSONObject(j);
                    map.put(userCalendar.getString("name"), userCalendar);
                }
                String filtered = null;
                try {
                    String[] calendarIdList;
                    for (String calId : calendarIdList = this.getCalendarsIdList(username)) {
                        org.exoplatform.calendar.model.Calendar calendar = this.extendedCalendarService.getCalendarHandler().getCalendarById(calId);
                        String calName = calendar.getName();
                        if (map.containsKey(calName)) {
                            JSONObject calTemp = (JSONObject)map.get(calName);
                            calendar.setCalendarColor(calTemp.getString("color"));
                            calendar.setCalendarOwner(username);
                            if (calTemp.has("type") && calTemp.getString("type").equals("user")) {
                                this.extendedCalendarService.getCalendarHandler().saveCalendar(calendar);
                                continue;
                            }
                            this.extendedCalendarService.getCalendarHandler().saveCalendar(calendar);
                            continue;
                        }
                        filtered = calendar.getId();
                    }
                    if (filtered == null) continue;
                    CalendarSetting setting = this.calendarService.getCalendarSetting(username);
                    setting.setFilterPublicCalendars(new String[]{filtered});
                    this.calendarService.saveCalendarSetting(username, setting);
                }
                catch (Exception e) {
                    this.LOG.error("Cannot create user calendar", new Object[]{e, e.getMessage()});
                }
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on calendar n\u00b0" + i), (Throwable)e);
            }
        }
    }

    public void createEvents(JSONArray calendars) {
        for (int i = 0; i < calendars.length(); ++i) {
            try {
                JSONObject calendarObject = calendars.getJSONObject(i);
                String username = calendarObject.getString("user");
                Map<String, String> map = this.getCalendarsMap(username);
                if (calendarObject.has("clearAll") && calendarObject.getBoolean("clearAll")) {
                    this.removeAllEvents(username);
                }
                JSONArray userCalendars = calendarObject.getJSONArray("calendars");
                for (int j = 0; j < userCalendars.length(); ++j) {
                    JSONObject userCalendar = userCalendars.getJSONObject(j);
                    JSONArray events = userCalendar.getJSONArray("events");
                    for (int k = 0; k < events.length(); ++k) {
                        JSONObject event = events.getJSONObject(k);
                        this.saveEvent(username, userCalendar.has("type") && userCalendar.getString("type").equals("user"), map.get(userCalendar.getString("name")), event.getString("title"), InjectorUtils.getDayAsInt(event.getString("day")), InjectorUtils.getHourAsInt(event.getString("start")), InjectorUtils.getMinuteAsInt(event.getString("start")), InjectorUtils.getHourAsInt(event.getString("end")), InjectorUtils.getMinuteAsInt(event.getString("end")));
                    }
                }
                continue;
            }
            catch (JSONException e) {
                this.LOG.error((Object)("Syntax error on calendar n\u00b0" + i), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                this.LOG.error("Cannot created event", new Object[]{e, e.getMessage()});
            }
        }
    }

    private void saveEvent(String username, boolean isUserEvent, String calId, String summary, int day, int fromHour, int fromMin, int toHour, int toMin) throws Exception {
        CalendarEvent event = new CalendarEvent();
        event.setCalendarId(calId);
        event.setSummary(summary);
        event.setEventType(Event.TYPE_EVENT);
        event.setRepeatType(Event.RP_NOREPEAT);
        event.setPrivate(isUserEvent);
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTime().getTime());
        calendar.set(7, day);
        calendar.set(11, fromHour);
        calendar.set(12, fromMin);
        event.setFromDateTime(calendar.getTime());
        calendar.set(11, toHour);
        calendar.set(12, toMin);
        event.setToDateTime(calendar.getTime());
        if (isUserEvent) {
            this.calendarService.saveUserEvent(username, calId, event, true);
        } else {
            this.calendarService.savePublicEvent(calId, event, true);
        }
    }

    private void removeAllEvents(String username) throws Exception {
        List<CalendarEvent> events = this.getEvents(username);
        for (CalendarEvent event : events) {
            if (event.isPrivate()) {
                this.calendarService.removeUserEvent(username, event.getCalendarId(), event.getId());
                continue;
            }
            this.calendarService.removePublicEvent(event.getCalendarId(), event.getId());
        }
    }

    private Map<String, String> getCalendarsMap(String username) {
        String[] calendarIdList;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String calId : calendarIdList = this.getCalendarsIdList(username)) {
            Calendar calendar = null;
            try {
                calendar = this.calendarService.getCalendarById(calId);
                String calName = calendar.getName();
                map.put(calName, calId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    private String[] getCalendarsIdList(String username) {
        StringBuilder sb = new StringBuilder();
        List listgroupCalendar = null;
        List listUserCalendar = null;
        try {
            listgroupCalendar = this.calendarService.getGroupCalendars(this.getUserGroups(username), true, username);
            listUserCalendar = this.calendarService.getUserCalendars(username, true);
        }
        catch (Exception e) {
            this.LOG.info((Object)("Error while checking User Calendar :" + e.getMessage()));
        }
        for (GroupCalendarData g : listgroupCalendar) {
            for (Calendar c : g.getCalendars()) {
                sb.append(c.getId()).append(",");
            }
        }
        for (Calendar c : listUserCalendar) {
            sb.append(c.getId()).append(",");
        }
        String[] list = sb.toString().split(",");
        return list;
    }

    private List<CalendarEvent> getEvents(String username) {
        String[] calList = this.getCalendarsIdList(username);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
        eventQuery.setCalendarId(calList);
        List userEvents = null;
        try {
            userEvents = this.calendarService.getEvents(username, eventQuery, calList);
        }
        catch (Exception e) {
            this.LOG.info((Object)("Error while checking User Events:" + e.getMessage()));
        }
        return userEvents;
    }

    private String[] getUserGroups(String username) throws Exception {
        Object[] objs = this.organizationService.getGroupHandler().findGroupsOfUser(username).toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }
}

